/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2;

import com.linkedin.d2.D2ClusterPartitionConfiguration;
import com.linkedin.d2.D2UriArray;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;

public class D2Cluster
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"D2Cluster\",\"namespace\":\"com.linkedin.d2\",\"doc\":\"A cluster as represented in D2\",\"include\":[{\"type\":\"record\",\"name\":\"D2ChangeTimeStamps\",\"doc\":\"Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages.\",\"fields\":[{\"name\":\"created\",\"type\":\"long\",\"doc\":\"A timestamp corresponding to the creation of this resource/association/sub-resource\"},{\"name\":\"lastModified\",\"type\":\"long\",\"doc\":\"A timestamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created\"},{\"name\":\"deleted\",\"type\":\"long\",\"doc\":\"A timestamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.\",\"optional\":true}]}],\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"The name of the cluster\"},{\"name\":\"services\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"The services that this cluster can provide\",\"default\":[]},{\"name\":\"uris\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"D2Uri\",\"doc\":\"A URI resource as represented in D2\",\"fields\":[{\"name\":\"URI\",\"type\":\"string\",\"doc\":\"URI for this machine.\"},{\"name\":\"clusterName\",\"type\":\"string\",\"doc\":\"The cluster where this URI belongs.\"},{\"name\":\"partitionDescription\",\"type\":{\"type\":\"map\",\"values\":\"double\"},\"doc\":\"partitionId key to weight\"}]}},\"doc\":\"The URIs of machines that belong to this cluster\",\"default\":[]},{\"name\":\"partitionConfiguration\",\"type\":{\"type\":\"record\",\"name\":\"D2ClusterPartitionConfiguration\",\"doc\":\"Partitioning configuration for D2 clusters\",\"fields\":[{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"PartitionTypeEnum\",\"symbols\":[\"HASH\",\"RANGE\",\"NONE\"]},\"doc\":\"The type of partitioning. We support HASH, RANGE, NONE.\",\"symbolDocs\":{\"NONE\":\"No Partitioning.\",\"RANGE\":\"partitioning based on range e.g. Id 1-1000 goes to bucket A, Id 1001-2000 goes to bucket B, etc.\",\"HASH\":\"Partitioning based on hash.\"}},{\"name\":\"partitionKeyRegex\",\"type\":\"string\",\"doc\":\"The regular expression to extract the partition key from a request URI.\",\"optional\":true},{\"name\":\"partitionCount\",\"type\":\"int\",\"doc\":\"The number of partitions this cluster has.\",\"optional\":true},{\"name\":\"partitionTypeSpecificData\",\"type\":[{\"type\":\"record\",\"name\":\"rangedPartitionProperties\",\"fields\":[{\"name\":\"partitionSize\",\"type\":\"long\",\"doc\":\"The size of each partition. Used only for RANGE based partition. Not used for HASH based partition\"},{\"name\":\"keyRangeStart\",\"type\":\"long\",\"doc\":\"The starting point for RANGE partitioning. Not used for HASH based partition.\"}]},{\"type\":\"enum\",\"name\":\"hashAlgorithm\",\"doc\":\"The hashing algorithm used in HASH based partitioning. Supported algorithms are: MODULO or MD5. Not used for RANGE based partition.\",\"symbols\":[\"MODULO\",\"MD5\"],\"symbolDocs\":{\"MODULO\":\"Mod the key with partitionCount to get the partitionKey\",\"MD5\":\"Hash the key and mod it with partitionCount to get the partitionKey\"}}],\"doc\":\"If the partition type is RANGE, then we have rangedPartitionProperties. If it's type HASH, we should have a hashAlgorithm. Otherwise we won't have any extra data in this field\",\"optional\":true}]},\"doc\":\"If this cluster has partitioning, then this is the partition config of this cluster\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_LastModified = SCHEMA.getField("lastModified");
    private static final RecordDataSchema.Field FIELD_Deleted = SCHEMA.getField("deleted");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Services = SCHEMA.getField("services");
    private static final RecordDataSchema.Field FIELD_Uris = SCHEMA.getField("uris");
    private static final RecordDataSchema.Field FIELD_PartitionConfiguration = SCHEMA.getField("partitionConfiguration");

    public D2Cluster() {
        super(new DataMap(), SCHEMA);
    }

    public D2Cluster(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasCreated() {
        return this.contains(FIELD_Created);
    }

    public void removeCreated() {
        this.remove(FIELD_Created);
    }

    public Long getCreated(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_Created, Long.class, mode);
    }

    public Long getCreated() {
        return (Long)this.obtainDirect(FIELD_Created, Long.class, GetMode.STRICT);
    }

    public D2Cluster setCreated(Long value, SetMode mode) {
        this.putDirect(FIELD_Created, Long.class, Long.class, value, mode);
        return this;
    }

    public D2Cluster setCreated(Long value) {
        this.putDirect(FIELD_Created, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2Cluster setCreated(long value) {
        this.putDirect(FIELD_Created, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLastModified() {
        return this.contains(FIELD_LastModified);
    }

    public void removeLastModified() {
        this.remove(FIELD_LastModified);
    }

    public Long getLastModified(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_LastModified, Long.class, mode);
    }

    public Long getLastModified() {
        return (Long)this.obtainDirect(FIELD_LastModified, Long.class, GetMode.STRICT);
    }

    public D2Cluster setLastModified(Long value, SetMode mode) {
        this.putDirect(FIELD_LastModified, Long.class, Long.class, value, mode);
        return this;
    }

    public D2Cluster setLastModified(Long value) {
        this.putDirect(FIELD_LastModified, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2Cluster setLastModified(long value) {
        this.putDirect(FIELD_LastModified, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDeleted() {
        return this.contains(FIELD_Deleted);
    }

    public void removeDeleted() {
        this.remove(FIELD_Deleted);
    }

    public Long getDeleted(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_Deleted, Long.class, mode);
    }

    public Long getDeleted() {
        return (Long)this.obtainDirect(FIELD_Deleted, Long.class, GetMode.STRICT);
    }

    public D2Cluster setDeleted(Long value, SetMode mode) {
        this.putDirect(FIELD_Deleted, Long.class, Long.class, value, mode);
        return this;
    }

    public D2Cluster setDeleted(Long value) {
        this.putDirect(FIELD_Deleted, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2Cluster setDeleted(long value) {
        this.putDirect(FIELD_Deleted, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasName() {
        return this.contains(FIELD_Name);
    }

    public void removeName() {
        this.remove(FIELD_Name);
    }

    public String getName(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Name, String.class, mode);
    }

    public String getName() {
        return (String)this.obtainDirect(FIELD_Name, String.class, GetMode.STRICT);
    }

    public D2Cluster setName(String value, SetMode mode) {
        this.putDirect(FIELD_Name, String.class, String.class, value, mode);
        return this;
    }

    public D2Cluster setName(String value) {
        this.putDirect(FIELD_Name, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasServices() {
        return this.contains(FIELD_Services);
    }

    public void removeServices() {
        this.remove(FIELD_Services);
    }

    public StringArray getServices(GetMode mode) {
        return (StringArray)this.obtainWrapped(FIELD_Services, StringArray.class, mode);
    }

    public StringArray getServices() {
        return (StringArray)this.obtainWrapped(FIELD_Services, StringArray.class, GetMode.STRICT);
    }

    public D2Cluster setServices(StringArray value, SetMode mode) {
        this.putWrapped(FIELD_Services, StringArray.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Cluster setServices(StringArray value) {
        this.putWrapped(FIELD_Services, StringArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasUris() {
        return this.contains(FIELD_Uris);
    }

    public void removeUris() {
        this.remove(FIELD_Uris);
    }

    public D2UriArray getUris(GetMode mode) {
        return (D2UriArray)this.obtainWrapped(FIELD_Uris, D2UriArray.class, mode);
    }

    public D2UriArray getUris() {
        return (D2UriArray)this.obtainWrapped(FIELD_Uris, D2UriArray.class, GetMode.STRICT);
    }

    public D2Cluster setUris(D2UriArray value, SetMode mode) {
        this.putWrapped(FIELD_Uris, D2UriArray.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Cluster setUris(D2UriArray value) {
        this.putWrapped(FIELD_Uris, D2UriArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPartitionConfiguration() {
        return this.contains(FIELD_PartitionConfiguration);
    }

    public void removePartitionConfiguration() {
        this.remove(FIELD_PartitionConfiguration);
    }

    public D2ClusterPartitionConfiguration getPartitionConfiguration(GetMode mode) {
        return (D2ClusterPartitionConfiguration)this.obtainWrapped(FIELD_PartitionConfiguration, D2ClusterPartitionConfiguration.class, mode);
    }

    public D2ClusterPartitionConfiguration getPartitionConfiguration() {
        return (D2ClusterPartitionConfiguration)this.obtainWrapped(FIELD_PartitionConfiguration, D2ClusterPartitionConfiguration.class, GetMode.STRICT);
    }

    public D2Cluster setPartitionConfiguration(D2ClusterPartitionConfiguration value, SetMode mode) {
        this.putWrapped(FIELD_PartitionConfiguration, D2ClusterPartitionConfiguration.class, (DataTemplate)value, mode);
        return this;
    }

    public D2Cluster setPartitionConfiguration(D2ClusterPartitionConfiguration value) {
        this.putWrapped(FIELD_PartitionConfiguration, D2ClusterPartitionConfiguration.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2Cluster clone() throws CloneNotSupportedException {
        return (D2Cluster)super.clone();
    }

    public D2Cluster copy() throws CloneNotSupportedException {
        return (D2Cluster)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec created() {
            return new PathSpec(this.getPathComponents(), "created");
        }

        public PathSpec lastModified() {
            return new PathSpec(this.getPathComponents(), "lastModified");
        }

        public PathSpec deleted() {
            return new PathSpec(this.getPathComponents(), "deleted");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec services() {
            return new PathSpec(this.getPathComponents(), "services");
        }

        public D2UriArray.Fields uris() {
            return new D2UriArray.Fields(this.getPathComponents(), "uris");
        }

        public D2ClusterPartitionConfiguration.Fields partitionConfiguration() {
            return new D2ClusterPartitionConfiguration.Fields(this.getPathComponents(), "partitionConfiguration");
        }
    }
}

