/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractCSVToBean;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsvToBean<T>
extends AbstractCSVToBean {
    private Map<Class<?>, PropertyEditor> editorMap = null;
    private List<CsvException> capturedExceptions = null;

    public List<T> parse(MappingStrategy<T> mapper, Reader reader) {
        return this.parse(mapper, new CSVReader(reader), null, true);
    }

    public List<T> parse(MappingStrategy<T> mapper, Reader reader, boolean throwExceptions) {
        return this.parse(mapper, new CSVReader(reader), null, throwExceptions);
    }

    public List<T> parse(MappingStrategy<T> mapper, Reader reader, CsvToBeanFilter filter) {
        return this.parse(mapper, new CSVReader(reader), filter, true);
    }

    public List<T> parse(MappingStrategy<T> mapper, Reader reader, CsvToBeanFilter filter, boolean throwExceptions) {
        return this.parse(mapper, new CSVReader(reader), filter, throwExceptions);
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv) {
        return this.parse(mapper, csv, null, true);
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, boolean throwExceptions) {
        return this.parse(mapper, csv, null, throwExceptions);
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, CsvToBeanFilter filter) {
        return this.parse(mapper, csv, filter, true);
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, CsvToBeanFilter filter, boolean throwExceptions) {
        long lineProcessed = 0L;
        Object[] line = null;
        try {
            mapper.captureHeader(csv);
        }
        catch (Exception e) {
            throw new RuntimeException("Error capturing CSV header!", e);
        }
        try {
            ArrayList list = new ArrayList();
            while (null != (line = csv.readNext())) {
                ++lineProcessed;
                try {
                    this.processLine(mapper, filter, (String[])line, list);
                }
                catch (CsvException e) {
                    CsvException csve = e;
                    csve.setLineNumber(lineProcessed);
                    if (throwExceptions) {
                        throw csve;
                    }
                    this.getCapturedExceptions().add(csve);
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing CSV line: " + lineProcessed + " values: " + Arrays.toString(line), e);
        }
    }

    private void processLine(MappingStrategy<T> mapper, CsvToBeanFilter filter, String[] line, List<T> list) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException, CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        if (filter == null || filter.allowLine(line)) {
            T obj = this.processLine(mapper, line);
            list.add(obj);
        }
    }

    protected T processLine(MappingStrategy<T> mapper, String[] line) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException, CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        T bean = mapper.createBean();
        for (int col = 0; col < line.length; ++col) {
            if (mapper.isAnnotationDriven()) {
                this.processField(mapper, line, bean, col);
                continue;
            }
            this.processProperty(mapper, line, bean, col);
        }
        return bean;
    }

    private void processProperty(MappingStrategy<T> mapper, String[] line, T bean, int col) throws IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException, CsvBadConverterException {
        PropertyDescriptor prop = mapper.findDescriptor(col);
        if (null != prop) {
            String value = this.checkForTrim(line[col], prop);
            Object obj = this.convertValue(value, prop);
            prop.getWriteMethod().invoke(bean, obj);
        }
    }

    private void processField(MappingStrategy<T> mapper, String[] line, T bean, int col) throws CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        BeanField beanField = mapper.findField(col);
        if (beanField != null) {
            String value = line[col];
            beanField.setFieldValue(bean, value);
        }
    }

    private PropertyEditor getPropertyEditorValue(Class<?> cls) {
        PropertyEditor editor;
        if (this.editorMap == null) {
            this.editorMap = new HashMap();
        }
        if ((editor = this.editorMap.get(cls)) == null) {
            editor = PropertyEditorManager.findEditor(cls);
            this.addEditorToMap(cls, editor);
        }
        return editor;
    }

    private void addEditorToMap(Class<?> cls, PropertyEditor editor) {
        if (editor != null) {
            this.editorMap.put(cls, editor);
        }
    }

    @Override
    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> cls = desc.getPropertyEditorClass();
        if (null != cls) {
            return (PropertyEditor)cls.newInstance();
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }

    public List<CsvException> getCapturedExceptions() {
        if (this.capturedExceptions == null) {
            this.capturedExceptions = new ArrayList<CsvException>();
        }
        return this.capturedExceptions;
    }
}

