/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.session;

import azkaban.utils.Props;
import azkaban.utils.cache.Cache;
import azkaban.utils.cache.CacheManager;
import azkaban.webapp.session.Session;

public class SessionCache {
    private static final int MAX_NUM_SESSIONS = 10000;
    private static final long SESSION_TIME_TO_LIVE = 86400000L;
    private Cache cache;

    public SessionCache(Props props) {
        CacheManager manager = CacheManager.getInstance();
        this.cache = manager.createCache();
        this.cache.setEjectionPolicy(Cache.EjectionPolicy.LRU);
        this.cache.setMaxCacheSize(props.getInt("max.num.sessions", 10000));
        this.cache.setExpiryTimeToLiveMs(props.getLong("session.time.to.live", 86400000L));
    }

    public Session getSession(String sessionId) {
        Session elem = (Session)this.cache.get(sessionId);
        return elem;
    }

    public void addSession(Session session) {
        this.cache.put(session.getSessionId(), session);
    }

    public boolean removeSession(String id) {
        return this.cache.remove(id);
    }
}

