/*
 * Decompiled with CFR 0.152.
 */
package azkaban.migration.scheduler;

import azkaban.executor.ExecutionOptions;
import azkaban.migration.sla.SlaOptions;
import azkaban.utils.Pair;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;

@Deprecated
public class Schedule {
    private int projectId;
    private String projectName;
    private String flowName;
    private long firstSchedTime;
    private DateTimeZone timezone;
    private long lastModifyTime;
    private ReadablePeriod period;
    private long nextExecTime;
    private String submitUser;
    private String status;
    private long submitTime;
    private ExecutionOptions executionOptions;
    private SlaOptions slaOptions;

    public Schedule(int projectId, String projectName, String flowName, String status, long firstSchedTime, DateTimeZone timezone, ReadablePeriod period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.flowName = flowName;
        this.firstSchedTime = firstSchedTime;
        this.timezone = timezone;
        this.lastModifyTime = lastModifyTime;
        this.period = period;
        this.nextExecTime = nextExecTime;
        this.submitUser = submitUser;
        this.status = status;
        this.submitTime = submitTime;
        this.executionOptions = null;
        this.slaOptions = null;
    }

    public Schedule(int projectId, String projectName, String flowName, String status, long firstSchedTime, String timezoneId, String period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser, ExecutionOptions executionOptions, SlaOptions slaOptions) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.flowName = flowName;
        this.firstSchedTime = firstSchedTime;
        this.timezone = DateTimeZone.forID((String)timezoneId);
        this.lastModifyTime = lastModifyTime;
        this.period = Schedule.parsePeriodString(period);
        this.nextExecTime = nextExecTime;
        this.submitUser = submitUser;
        this.status = status;
        this.submitTime = submitTime;
        this.executionOptions = executionOptions;
        this.slaOptions = slaOptions;
    }

    public Schedule(int projectId, String projectName, String flowName, String status, long firstSchedTime, DateTimeZone timezone, ReadablePeriod period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser, ExecutionOptions executionOptions, SlaOptions slaOptions) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.flowName = flowName;
        this.firstSchedTime = firstSchedTime;
        this.timezone = timezone;
        this.lastModifyTime = lastModifyTime;
        this.period = period;
        this.nextExecTime = nextExecTime;
        this.submitUser = submitUser;
        this.status = status;
        this.submitTime = submitTime;
        this.executionOptions = executionOptions;
        this.slaOptions = slaOptions;
    }

    public ExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    public void setFlowOptions(ExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
    }

    public SlaOptions getSlaOptions() {
        return this.slaOptions;
    }

    public void setSlaOptions(SlaOptions slaOptions) {
        this.slaOptions = slaOptions;
    }

    public String getScheduleName() {
        return this.projectName + "." + this.flowName + " (" + this.projectId + ")";
    }

    public String toString() {
        return this.projectName + "." + this.flowName + " (" + this.projectId + ")" + " to be run at (starting) " + new DateTime(this.firstSchedTime).toDateTimeISO() + " with recurring period of " + (this.period == null ? "non-recurring" : Schedule.createPeriodString(this.period));
    }

    public Pair<Integer, String> getScheduleId() {
        return new Pair<Integer, String>(this.getProjectId(), this.getFlowName());
    }

    public int getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public long getFirstSchedTime() {
        return this.firstSchedTime;
    }

    public DateTimeZone getTimezone() {
        return this.timezone;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public ReadablePeriod getPeriod() {
        return this.period;
    }

    public long getNextExecTime() {
        return this.nextExecTime;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    public String getStatus() {
        return this.status;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public boolean updateTime() {
        if (new DateTime(this.nextExecTime).isAfterNow()) {
            return true;
        }
        if (this.period != null) {
            DateTime nextTime = this.getNextRuntime(this.nextExecTime, this.timezone, this.period);
            this.nextExecTime = nextTime.getMillis();
            return true;
        }
        return false;
    }

    private DateTime getNextRuntime(long scheduleTime, DateTimeZone timezone, ReadablePeriod period) {
        DateTime now = new DateTime();
        DateTime date = new DateTime(scheduleTime).withZone(timezone);
        int count = 0;
        while (!now.isBefore((ReadableInstant)date)) {
            if (count > 100000) {
                throw new IllegalStateException("100000 increments of period did not get to present time.");
            }
            if (period == null) break;
            date = date.plus(period);
            ++count;
        }
        return date;
    }

    public static ReadablePeriod parsePeriodString(String periodStr) {
        Months period;
        char periodUnit = periodStr.charAt(periodStr.length() - 1);
        if (periodUnit == 'n') {
            return null;
        }
        int periodInt = Integer.parseInt(periodStr.substring(0, periodStr.length() - 1));
        switch (periodUnit) {
            case 'M': {
                period = Months.months((int)periodInt);
                break;
            }
            case 'w': {
                period = Weeks.weeks((int)periodInt);
                break;
            }
            case 'd': {
                period = Days.days((int)periodInt);
                break;
            }
            case 'h': {
                period = Hours.hours((int)periodInt);
                break;
            }
            case 'm': {
                period = Minutes.minutes((int)periodInt);
                break;
            }
            case 's': {
                period = Seconds.seconds((int)periodInt);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid schedule period unit '" + periodUnit);
            }
        }
        return period;
    }

    public static String createPeriodString(ReadablePeriod period) {
        String periodStr = "n";
        if (period == null) {
            return "n";
        }
        if (period.get(DurationFieldType.months()) > 0) {
            int months = period.get(DurationFieldType.months());
            periodStr = months + "M";
        } else if (period.get(DurationFieldType.weeks()) > 0) {
            int weeks = period.get(DurationFieldType.weeks());
            periodStr = weeks + "w";
        } else if (period.get(DurationFieldType.days()) > 0) {
            int days = period.get(DurationFieldType.days());
            periodStr = days + "d";
        } else if (period.get(DurationFieldType.hours()) > 0) {
            int hours = period.get(DurationFieldType.hours());
            periodStr = hours + "h";
        } else if (period.get(DurationFieldType.minutes()) > 0) {
            int minutes = period.get(DurationFieldType.minutes());
            periodStr = minutes + "m";
        } else if (period.get(DurationFieldType.seconds()) > 0) {
            int seconds = period.get(DurationFieldType.seconds());
            periodStr = seconds + "s";
        }
        return periodStr;
    }

    public Map<String, Object> optionsToObject() {
        if (this.executionOptions != null || this.slaOptions != null) {
            HashMap<String, Object> schedObj = new HashMap<String, Object>();
            if (this.executionOptions != null) {
                schedObj.put("executionOptions", this.executionOptions.toObject());
            }
            if (this.slaOptions != null) {
                schedObj.put("slaOptions", this.slaOptions.toObject());
            }
            return schedObj;
        }
        return null;
    }

    public void createAndSetScheduleOptions(Object obj) {
        ExecutionOptions execOptions;
        HashMap schedObj = (HashMap)obj;
        if (schedObj.containsKey("executionOptions")) {
            this.executionOptions = execOptions = ExecutionOptions.createFromObject(schedObj.get("executionOptions"));
        } else if (schedObj.containsKey("flowOptions")) {
            this.executionOptions = execOptions = ExecutionOptions.createFromObject(schedObj.get("flowOptions"));
            execOptions.setConcurrentOption("skip");
        } else {
            this.executionOptions = new ExecutionOptions();
            this.executionOptions.setConcurrentOption("skip");
        }
        if (schedObj.containsKey("slaOptions")) {
            SlaOptions slaOptions;
            this.slaOptions = slaOptions = SlaOptions.fromObject(schedObj.get("slaOptions"));
        }
    }
}

