/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp;

import azkaban.execapp.FlowRunner;
import azkaban.execapp.ProjectVersion;
import azkaban.execapp.event.Event;
import azkaban.execapp.event.EventListener;
import azkaban.execapp.event.FlowWatcher;
import azkaban.execapp.event.LocalFlowWatcher;
import azkaban.execapp.event.RemoteFlowWatcher;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.jobtype.JobTypeManager;
import azkaban.project.ProjectLoader;
import azkaban.utils.FileIOUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class FlowRunnerManager
implements EventListener {
    private static Logger logger = Logger.getLogger(FlowRunnerManager.class);
    private File executionDirectory;
    private File projectDirectory;
    private static final long RECENTLY_FINISHED_TIME_TO_LIVE = 60000L;
    private static final int DEFAULT_NUM_EXECUTING_FLOWS = 30;
    private Map<Pair<Integer, Integer>, ProjectVersion> installedProjects = new ConcurrentHashMap<Pair<Integer, Integer>, ProjectVersion>();
    private Map<Integer, FlowRunner> runningFlows = new ConcurrentHashMap<Integer, FlowRunner>();
    private Map<Integer, ExecutableFlow> recentlyFinishedFlows = new ConcurrentHashMap<Integer, ExecutableFlow>();
    private LinkedBlockingQueue<FlowRunner> flowQueue = new LinkedBlockingQueue();
    private int numThreads = 30;
    private ExecutorService executorService;
    private SubmitterThread submitterThread;
    private CleanerThread cleanerThread;
    private int numJobThreadPerFlow = 10;
    private ExecutorLoader executorLoader;
    private ProjectLoader projectLoader;
    private JobTypeManager jobtypeManager;
    private Props globalProps;
    private final Props azkabanProps;
    private long lastSubmitterThreadCheckTime = -1L;
    private long lastCleanerThreadCheckTime = -1L;
    private long executionDirRetention = 86400000L;
    private String jobLogChunkSize = "5MB";
    private int jobLogNumFiles = 4;
    private boolean validateProxyUser = false;
    private Object executionDirDeletionSync = new Object();

    public FlowRunnerManager(Props props, ExecutorLoader executorLoader, ProjectLoader projectLoader, ClassLoader parentClassLoader) throws IOException {
        this.executionDirectory = new File(props.getString("azkaban.execution.dir", "executions"));
        this.projectDirectory = new File(props.getString("azkaban.project.dir", "projects"));
        this.azkabanProps = props;
        this.executionDirRetention = props.getLong("execution.dir.retention", this.executionDirRetention);
        logger.info((Object)("Execution dir retention set to " + this.executionDirRetention + " ms"));
        if (!this.executionDirectory.exists()) {
            this.executionDirectory.mkdirs();
        }
        if (!this.projectDirectory.exists()) {
            this.projectDirectory.mkdirs();
        }
        this.installedProjects = this.loadExistingProjects();
        this.numThreads = props.getInt("executor.flow.threads", 30);
        this.numJobThreadPerFlow = props.getInt("flow.num.job.threads", this.numJobThreadPerFlow);
        this.executorService = Executors.newFixedThreadPool(this.numThreads);
        this.executorLoader = executorLoader;
        this.projectLoader = projectLoader;
        this.jobLogChunkSize = this.azkabanProps.getString("job.log.chunk.size", "5MB");
        this.jobLogNumFiles = this.azkabanProps.getInt("job.log.backup.index", 4);
        this.validateProxyUser = this.azkabanProps.getBoolean("proxy.user.lock.down", false);
        this.submitterThread = new SubmitterThread(this.flowQueue);
        this.submitterThread.start();
        this.cleanerThread = new CleanerThread();
        this.cleanerThread.start();
        this.jobtypeManager = new JobTypeManager(props.getString("azkaban.jobtype.plugin.dir", "plugins/jobtypes"), parentClassLoader);
    }

    private Map<Pair<Integer, Integer>, ProjectVersion> loadExistingProjects() {
        HashMap<Pair<Integer, Integer>, ProjectVersion> allProjects = new HashMap<Pair<Integer, Integer>, ProjectVersion>();
        for (File project : this.projectDirectory.listFiles(new FilenameFilter(){
            String pattern = "[0-9]+\\.[0-9]+";

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(this.pattern);
            }
        })) {
            if (!project.isDirectory()) continue;
            try {
                String fileName = new File(project.getAbsolutePath()).getName();
                int projectId = Integer.parseInt(fileName.split("\\.")[0]);
                int versionNum = Integer.parseInt(fileName.split("\\.")[1]);
                ProjectVersion version = new ProjectVersion(projectId, versionNum, project);
                allProjects.put(new Pair<Integer, Integer>(projectId, versionNum), version);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return allProjects;
    }

    public Props getGlobalProps() {
        return this.globalProps;
    }

    public void setGlobalProps(Props globalProps) {
        this.globalProps = globalProps;
    }

    public void submitFlow(int execId) throws ExecutorManagerException {
        FlowRunner runner;
        if (this.runningFlows.containsKey(execId)) {
            throw new ExecutorManagerException("Execution " + execId + " is already running.");
        }
        ExecutableFlow flow = null;
        flow = this.executorLoader.fetchExecutableFlow(execId);
        if (flow == null) {
            throw new ExecutorManagerException("Error loading flow with exec " + execId);
        }
        this.setupFlow(flow);
        FlowWatcher watcher = null;
        ExecutionOptions options = flow.getExecutionOptions();
        if (options.getPipelineExecutionId() != null) {
            Integer pipelineExecId = options.getPipelineExecutionId();
            runner = this.runningFlows.get(pipelineExecId);
            watcher = runner != null ? new LocalFlowWatcher(runner) : new RemoteFlowWatcher(pipelineExecId, this.executorLoader);
        }
        int numJobThreads = this.numJobThreadPerFlow;
        if (options.getFlowParameters().containsKey("flow.num.job.threads")) {
            try {
                int numJobs = Integer.valueOf(options.getFlowParameters().get("flow.num.job.threads"));
                if (numJobs > 0 && numJobs <= numJobThreads) {
                    numJobThreads = numJobs;
                }
            }
            catch (Exception e) {
                throw new ExecutorManagerException("Failed to set the number of job threads " + options.getFlowParameters().get("flow.num.job.threads") + " for flow " + execId, e);
            }
        }
        runner = new FlowRunner(flow, this.executorLoader, this.projectLoader, this.jobtypeManager);
        runner.setFlowWatcher(watcher).setJobLogSettings(this.jobLogChunkSize, this.jobLogNumFiles).setValidateProxyUser(this.validateProxyUser).setGlobalProps(this.globalProps).setNumJobThreads(numJobThreads).addListener(this);
        if (this.runningFlows.containsKey(execId)) {
            throw new ExecutorManagerException("Execution " + execId + " is already running.");
        }
        this.runningFlows.put(execId, runner);
        this.flowQueue.add(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFlow(ExecutableFlow flow) throws ExecutorManagerException {
        int execId = flow.getExecutionId();
        File execPath = new File(this.executionDirectory, String.valueOf(execId));
        flow.setExecutionPath(execPath.getPath());
        logger.info((Object)("Flow " + execId + " submitted with path " + execPath.getPath()));
        execPath.mkdirs();
        Pair<Integer, Integer> projectVersionKey = new Pair<Integer, Integer>(flow.getProjectId(), flow.getVersion());
        ProjectVersion projectVersion = null;
        Map<Pair<Integer, Integer>, ProjectVersion> map = this.installedProjects;
        synchronized (map) {
            projectVersion = this.installedProjects.get(projectVersionKey);
            if (projectVersion == null) {
                projectVersion = new ProjectVersion(flow.getProjectId(), flow.getVersion());
                this.installedProjects.put(projectVersionKey, projectVersion);
            }
        }
        try {
            projectVersion.setupProjectFiles(this.projectLoader, this.projectDirectory, logger);
            projectVersion.copyCreateSymlinkDirectory(execPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (execPath.exists()) {
                try {
                    FileUtils.deleteDirectory((File)execPath);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            throw new ExecutorManagerException(e);
        }
    }

    public void cancelFlow(int execId, String user) throws ExecutorManagerException {
        FlowRunner runner = this.runningFlows.get(execId);
        if (runner == null) {
            throw new ExecutorManagerException("Execution " + execId + " is not running.");
        }
        runner.kill(user);
    }

    public void pauseFlow(int execId, String user) throws ExecutorManagerException {
        FlowRunner runner = this.runningFlows.get(execId);
        if (runner == null) {
            throw new ExecutorManagerException("Execution " + execId + " is not running.");
        }
        runner.pause(user);
    }

    public void resumeFlow(int execId, String user) throws ExecutorManagerException {
        FlowRunner runner = this.runningFlows.get(execId);
        if (runner == null) {
            throw new ExecutorManagerException("Execution " + execId + " is not running.");
        }
        runner.resume(user);
    }

    public void retryFailures(int execId, String user) throws ExecutorManagerException {
        FlowRunner runner = this.runningFlows.get(execId);
        if (runner == null) {
            throw new ExecutorManagerException("Execution " + execId + " is not running.");
        }
        runner.retryFailures(user);
    }

    public ExecutableFlow getExecutableFlow(int execId) {
        FlowRunner runner = this.runningFlows.get(execId);
        if (runner == null) {
            return this.recentlyFinishedFlows.get(execId);
        }
        return runner.getExecutableFlow();
    }

    @Override
    public void handleEvent(Event event) {
        if (event.getType() == Event.Type.FLOW_FINISHED) {
            FlowRunner flowRunner = (FlowRunner)event.getRunner();
            ExecutableFlow flow = flowRunner.getExecutableFlow();
            this.recentlyFinishedFlows.put(flow.getExecutionId(), flow);
            logger.info((Object)("Flow " + flow.getExecutionId() + " is finished. Adding it to recently finished flows list."));
            this.runningFlows.remove(flow.getExecutionId());
        }
    }

    public FileIOUtils.LogData readFlowLogs(int execId, int startByte, int length) throws ExecutorManagerException {
        FlowRunner runner = this.runningFlows.get(execId);
        if (runner == null) {
            throw new ExecutorManagerException("Running flow " + execId + " not found.");
        }
        File dir = runner.getExecutionDir();
        if (dir != null && dir.exists()) {
            try {
                Object object = this.executionDirDeletionSync;
                synchronized (object) {
                    if (!dir.exists()) {
                        throw new ExecutorManagerException("Execution dir file doesn't exist. Probably has beend deleted");
                    }
                    File logFile = runner.getFlowLogFile();
                    if (logFile != null && logFile.exists()) {
                        return FileIOUtils.readUtf8File(logFile, startByte, length);
                    }
                    throw new ExecutorManagerException("Flow log file doesn't exist.");
                }
            }
            catch (IOException e) {
                throw new ExecutorManagerException(e);
            }
        }
        throw new ExecutorManagerException("Error reading file. Log directory doesn't exist.");
    }

    public FileIOUtils.LogData readJobLogs(int execId, String jobId, int attempt, int startByte, int length) throws ExecutorManagerException {
        FlowRunner runner = this.runningFlows.get(execId);
        if (runner == null) {
            throw new ExecutorManagerException("Running flow " + execId + " not found.");
        }
        File dir = runner.getExecutionDir();
        if (dir != null && dir.exists()) {
            try {
                Object object = this.executionDirDeletionSync;
                synchronized (object) {
                    if (!dir.exists()) {
                        throw new ExecutorManagerException("Execution dir file doesn't exist. Probably has beend deleted");
                    }
                    File logFile = runner.getJobLogFile(jobId, attempt);
                    if (logFile != null && logFile.exists()) {
                        return FileIOUtils.readUtf8File(logFile, startByte, length);
                    }
                    throw new ExecutorManagerException("Job log file doesn't exist.");
                }
            }
            catch (IOException e) {
                throw new ExecutorManagerException(e);
            }
        }
        throw new ExecutorManagerException("Error reading file. Log directory doesn't exist.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> readJobAttachments(int execId, String jobId, int attempt) throws ExecutorManagerException {
        FlowRunner runner = this.runningFlows.get(execId);
        if (runner == null) {
            throw new ExecutorManagerException("Running flow " + execId + " not found.");
        }
        File dir = runner.getExecutionDir();
        if (dir == null || !dir.exists()) {
            throw new ExecutorManagerException("Error reading file. Log directory doesn't exist.");
        }
        try {
            Object object = this.executionDirDeletionSync;
            synchronized (object) {
                if (!dir.exists()) {
                    throw new ExecutorManagerException("Execution dir file doesn't exist. Probably has beend deleted");
                }
                File attachmentFile = runner.getJobAttachmentFile(jobId, attempt);
                if (attachmentFile == null || !attachmentFile.exists()) {
                    return null;
                }
                ArrayList jobAttachments = (ArrayList)JSONUtils.parseJSONFromFile(attachmentFile);
                return jobAttachments;
            }
        }
        catch (IOException e) {
            throw new ExecutorManagerException(e);
        }
    }

    public FileIOUtils.JobMetaData readJobMetaData(int execId, String jobId, int attempt, int startByte, int length) throws ExecutorManagerException {
        FlowRunner runner = this.runningFlows.get(execId);
        if (runner == null) {
            throw new ExecutorManagerException("Running flow " + execId + " not found.");
        }
        File dir = runner.getExecutionDir();
        if (dir != null && dir.exists()) {
            try {
                Object object = this.executionDirDeletionSync;
                synchronized (object) {
                    if (!dir.exists()) {
                        throw new ExecutorManagerException("Execution dir file doesn't exist. Probably has beend deleted");
                    }
                    File metaDataFile = runner.getJobMetaDataFile(jobId, attempt);
                    if (metaDataFile != null && metaDataFile.exists()) {
                        return FileIOUtils.readUtf8MetaDataFile(metaDataFile, startByte, length);
                    }
                    throw new ExecutorManagerException("Job log file doesn't exist.");
                }
            }
            catch (IOException e) {
                throw new ExecutorManagerException(e);
            }
        }
        throw new ExecutorManagerException("Error reading file. Log directory doesn't exist.");
    }

    public long getLastCleanerThreadCheckTime() {
        return this.lastCleanerThreadCheckTime;
    }

    public long getLastSubmitterThreadCheckTime() {
        return this.lastSubmitterThreadCheckTime;
    }

    public boolean isSubmitterThreadActive() {
        return this.submitterThread.isAlive();
    }

    public boolean isCleanerThreadActive() {
        return this.cleanerThread.isAlive();
    }

    public Thread.State getSubmitterThreadState() {
        return this.submitterThread.getState();
    }

    public Thread.State getCleanerThreadState() {
        return this.cleanerThread.getState();
    }

    public boolean isExecutorThreadPoolShutdown() {
        return this.executorService.isShutdown();
    }

    public int getNumExecutingFlows() {
        return this.runningFlows.size();
    }

    public String getRunningFlowIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>(this.runningFlows.keySet());
        Collections.sort(ids);
        return ids.toString();
    }

    public int getNumExecutingJobs() {
        int jobCount = 0;
        for (FlowRunner runner : this.runningFlows.values()) {
            jobCount += runner.getNumRunningJobs();
        }
        return jobCount;
    }

    private class CleanerThread
    extends Thread {
        private static final long EXECUTION_DIR_CLEAN_INTERVAL_MS = 3600000L;
        private static final long OLD_PROJECT_DIR_INTERVAL_MS = 300000L;
        private static final long RECENTLY_FINISHED_INTERVAL_MS = 120000L;
        private boolean shutdown = false;
        private long lastExecutionDirCleanTime = -1L;
        private long lastOldProjectCleanTime = -1L;
        private long lastRecentlyFinishedCleanTime = -1L;

        public CleanerThread() {
            this.setName("FlowRunnerManager-Cleaner-Thread");
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                CleanerThread cleanerThread = this;
                synchronized (cleanerThread) {
                    try {
                        FlowRunnerManager.this.lastCleanerThreadCheckTime = System.currentTimeMillis();
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - 120000L > this.lastRecentlyFinishedCleanTime) {
                            logger.info((Object)"Cleaning recently finished");
                            this.cleanRecentlyFinished();
                            this.lastRecentlyFinishedCleanTime = currentTime;
                        }
                        if (currentTime - 300000L > this.lastOldProjectCleanTime) {
                            logger.info((Object)"Cleaning old projects");
                            this.cleanOlderProjects();
                            this.lastOldProjectCleanTime = currentTime;
                        }
                        if (currentTime - 3600000L > this.lastExecutionDirCleanTime) {
                            logger.info((Object)"Cleaning old execution dirs");
                            this.cleanOlderExecutionDirs();
                            this.lastExecutionDirCleanTime = currentTime;
                        }
                        this.wait(60000L);
                    }
                    catch (InterruptedException e) {
                        logger.info((Object)"Interrupted. Probably to shut down.");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanOlderExecutionDirs() {
            File[] executionDirs;
            File dir = FlowRunnerManager.this.executionDirectory;
            final long pastTimeThreshold = System.currentTimeMillis() - FlowRunnerManager.this.executionDirRetention;
            for (File exDir : executionDirs = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File path) {
                    return path.isDirectory() && path.lastModified() < pastTimeThreshold;
                }
            })) {
                block9: {
                    try {
                        int execId = Integer.valueOf(exDir.getName());
                        if (FlowRunnerManager.this.runningFlows.containsKey(execId)) continue;
                        if (FlowRunnerManager.this.recentlyFinishedFlows.containsKey(execId)) {
                        }
                        break block9;
                    }
                    catch (NumberFormatException e) {
                        logger.error((Object)("Can't delete exec dir " + exDir.getName() + " it is not a number"));
                    }
                    continue;
                }
                Object object = FlowRunnerManager.this.executionDirDeletionSync;
                synchronized (object) {
                    try {
                        FileUtils.deleteDirectory((File)exDir);
                    }
                    catch (IOException e) {
                        logger.error((Object)("Error cleaning execution dir " + exDir.getPath()), (Throwable)e);
                    }
                }
            }
        }

        private void cleanRecentlyFinished() {
            long cleanupThreshold = System.currentTimeMillis() - 60000L;
            ArrayList<Integer> executionToKill = new ArrayList<Integer>();
            for (ExecutableFlow flow : FlowRunnerManager.this.recentlyFinishedFlows.values()) {
                if (flow.getEndTime() >= cleanupThreshold) continue;
                executionToKill.add(flow.getExecutionId());
            }
            for (Integer id : executionToKill) {
                logger.info((Object)("Cleaning execution " + id + " from recently finished flows list."));
                FlowRunnerManager.this.recentlyFinishedFlows.remove(id);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void cleanOlderProjects() {
            HashMap projectVersions = new HashMap();
            for (ProjectVersion version : FlowRunnerManager.this.installedProjects.values()) {
                void var4_4;
                ArrayList arrayList = (ArrayList)projectVersions.get(version.getProjectId());
                if (arrayList == null) {
                    ArrayList arrayList2 = new ArrayList();
                    projectVersions.put(version.getProjectId(), arrayList2);
                }
                var4_4.add(version);
            }
            HashSet<Pair<Integer, Integer>> activeProjectVersions = new HashSet<Pair<Integer, Integer>>();
            for (FlowRunner flowRunner : FlowRunnerManager.this.runningFlows.values()) {
                ExecutableFlow flow = flowRunner.getExecutableFlow();
                activeProjectVersions.add(new Pair<Integer, Integer>(flow.getProjectId(), flow.getVersion()));
            }
            for (Map.Entry entry : projectVersions.entrySet()) {
                ArrayList installedVersions = (ArrayList)entry.getValue();
                if (installedVersions.size() == 1) continue;
                Collections.sort(installedVersions);
                for (int i = 0; i < installedVersions.size() - 1; ++i) {
                    ProjectVersion version = (ProjectVersion)installedVersions.get(i);
                    Pair<Integer, Integer> versionKey = new Pair<Integer, Integer>(version.getProjectId(), version.getVersion());
                    if (activeProjectVersions.contains(versionKey)) continue;
                    try {
                        logger.info((Object)("Removing old unused installed project " + version.getProjectId() + ":" + version.getVersion()));
                        version.deleteDirectory();
                        FlowRunnerManager.this.installedProjects.remove(new Pair<Integer, Integer>(version.getProjectId(), version.getVersion()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    installedVersions.remove(versionKey);
                }
            }
        }
    }

    private class SubmitterThread
    extends Thread {
        private BlockingQueue<FlowRunner> queue;
        private boolean shutdown = false;

        public SubmitterThread(BlockingQueue<FlowRunner> queue) {
            this.setName("FlowRunnerManager-Submitter-Thread");
            this.queue = queue;
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    FlowRunnerManager.this.lastSubmitterThreadCheckTime = System.currentTimeMillis();
                    FlowRunner flowRunner = this.queue.take();
                    FlowRunnerManager.this.executorService.submit(flowRunner);
                }
                catch (InterruptedException e) {
                    logger.info((Object)"Interrupted. Probably to shut down.");
                }
            }
        }
    }
}

