/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.orchestration;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.service.modules.orchestration.AzkabanAjaxAPIClient;
import org.apache.gobblin.service.modules.orchestration.AzkabanProjectConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzkabanJobHelper {
    private static final Logger log = LoggerFactory.getLogger(AzkabanJobHelper.class);

    public static boolean isAzkabanJobPresent(String sessionId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info("Checking if Azkaban project: " + azkabanProjectConfig.getAzkabanProjectName() + " exists");
        try {
            boolean isPresent = StringUtils.isNotBlank((CharSequence)AzkabanAjaxAPIClient.getProjectId(sessionId, azkabanProjectConfig));
            log.info("Project exists: " + isPresent);
            return isPresent;
        }
        catch (IOException e) {
            if (String.format("Project %s doesn't exist.", azkabanProjectConfig.getAzkabanProjectName()).equalsIgnoreCase(e.getMessage())) {
                log.info("Project does not exists.");
                return false;
            }
            if ("Permission denied. Need READ access.".equalsIgnoreCase(e.getMessage())) {
                log.info("Project exists, but current user does not has READ access.");
                return true;
            }
            log.error("Issue in checking if project is present", (Throwable)e);
            throw e;
        }
    }

    public static String getProjectId(String sessionId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info("Getting project Id for project: " + azkabanProjectConfig.getAzkabanProjectName());
        String projectId = AzkabanAjaxAPIClient.getProjectId(sessionId, azkabanProjectConfig);
        log.info("Project id: " + projectId);
        return projectId;
    }

    public static String createAzkabanJob(String sessionId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info("Creating Azkaban project for: " + azkabanProjectConfig.getAzkabanProjectName());
        String zipFilePath = AzkabanJobHelper.createAzkabanJobZip(azkabanProjectConfig);
        log.info("Zip file path: " + zipFilePath);
        String projectId = AzkabanAjaxAPIClient.createAzkabanProject(sessionId, zipFilePath, azkabanProjectConfig);
        log.info("Project Id: " + projectId);
        return projectId;
    }

    public static void deleteAzkabanJob(String sessionId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info("Deleting Azkaban project for: " + azkabanProjectConfig.getAzkabanProjectName());
        AzkabanAjaxAPIClient.deleteAzkabanProject(sessionId, azkabanProjectConfig);
    }

    public static String replaceAzkabanJob(String sessionId, String azkabanProjectId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info("Replacing zip for Azkaban project: " + azkabanProjectConfig.getAzkabanProjectName());
        String zipFilePath = AzkabanJobHelper.createAzkabanJobZip(azkabanProjectConfig);
        log.info("Zip file path: " + zipFilePath);
        String projectId = AzkabanAjaxAPIClient.replaceAzkabanProject(sessionId, zipFilePath, azkabanProjectConfig);
        log.info("Project Id: " + projectId);
        return projectId;
    }

    public static void scheduleJob(String sessionId, String azkabanProjectId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info("Scheduling Azkaban project: " + azkabanProjectConfig.getAzkabanProjectName());
        AzkabanAjaxAPIClient.scheduleAzkabanProject(sessionId, azkabanProjectId, azkabanProjectConfig);
    }

    public static void changeJobSchedule(String sessionId, String azkabanProjectId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info("Changing schedule for Azkaban project: " + azkabanProjectConfig.getAzkabanProjectName());
        AzkabanAjaxAPIClient.scheduleAzkabanProject(sessionId, azkabanProjectId, azkabanProjectConfig);
    }

    public static void executeJob(String sessionId, String azkabanProjectId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info("Executing Azkaban project: " + azkabanProjectConfig.getAzkabanProjectName());
        AzkabanAjaxAPIClient.executeAzkabanProject(sessionId, azkabanProjectId, azkabanProjectConfig);
    }

    private static String createAzkabanJobZip(AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info("Creating Azkaban job zip file for project: " + azkabanProjectConfig.getAzkabanProjectName());
        String workDir = azkabanProjectConfig.getWorkDir();
        Optional<String> jarUrlTemplate = azkabanProjectConfig.getAzkabanZipJarUrlTemplate();
        Optional<List<String>> jarNames = azkabanProjectConfig.getAzkabanZipJarNames();
        Optional<String> jarVersion = azkabanProjectConfig.getAzkabanZipJarVersion();
        Optional<List<String>> additionalFiles = azkabanProjectConfig.getAzkabanZipAdditionalFiles();
        boolean failIfJarNotFound = azkabanProjectConfig.getFailIfJarNotFound();
        String jobFlowName = azkabanProjectConfig.getAzkabanProjectFlowName();
        String zipFilename = azkabanProjectConfig.getAzkabanProjectZipFilename();
        ArrayList filesToAdd = Lists.newArrayList();
        if (jarNames.isPresent() && jarUrlTemplate.isPresent() && jarVersion.isPresent()) {
            String urlTemplate = jarUrlTemplate.get();
            String version = jarVersion.get();
            for (String jarName : jarNames.get()) {
                String jobJarUrl = urlTemplate.replaceAll("<module-version>", version).replaceAll("<module-name>", jarName);
                log.info("Downloading job jar from: " + jobJarUrl + " to: " + workDir);
                File jobJarFile = null;
                try {
                    jobJarFile = AzkabanJobHelper.downloadAzkabanJobJar(workDir, jobJarUrl);
                    filesToAdd.add(jobJarFile);
                }
                catch (IOException e) {
                    if (failIfJarNotFound) {
                        throw e;
                    }
                    log.warn("Could not download: " + jobJarFile);
                }
            }
        }
        if (additionalFiles.isPresent()) {
            List<String> files = additionalFiles.get();
            for (String fileName : files) {
                log.info("Downloading additional file from: " + fileName + " to: " + workDir);
                File additionalFile = null;
                try {
                    additionalFile = AzkabanJobHelper.downloadAzkabanJobJar(workDir, fileName);
                    filesToAdd.add(additionalFile);
                }
                catch (IOException e) {
                    if (failIfJarNotFound) {
                        throw e;
                    }
                    log.warn("Could not download: " + additionalFile);
                }
            }
        }
        log.info("Writing Azkaban config files");
        File[] jobConfigFile = AzkabanJobHelper.writeAzkabanConfigFiles(workDir, jobFlowName, azkabanProjectConfig);
        filesToAdd.add(jobConfigFile[0]);
        log.info("Writing zip file");
        String zipfile = AzkabanJobHelper.createZipFile(workDir, zipFilename, filesToAdd);
        log.info("Wrote zip file: " + zipfile);
        return zipfile;
    }

    private static String createZipFile(String directory, String zipFilename, List<File> filesToAdd) throws IOException {
        String zipFilePath = String.format("%s/%s", directory, zipFilename);
        File zipFile = new File(zipFilePath);
        if (zipFile.exists()) {
            if (zipFile.delete()) {
                log.info("Zipfile existed and was deleted: " + zipFilePath);
            } else {
                log.warn("Zipfile exists but was not deleted: " + zipFilePath);
            }
        }
        AzkabanJobHelper.addFilesToZip(zipFile, filesToAdd);
        return zipFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Lombok construct of @Cleanup is handing this, but not detected by FindBugs")
    private static void addFilesToZip(File zipFile, List<File> filesToAdd) throws IOException {
        try {
            FileOutputStream archiveStream = new FileOutputStream(zipFile);
            try {
                ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)archiveStream);
                try {
                    for (File fileToAdd : filesToAdd) {
                        ZipArchiveEntry entry = new ZipArchiveEntry(fileToAdd.getName());
                        archive.putArchiveEntry((ArchiveEntry)entry);
                        BufferedInputStream input = new BufferedInputStream(new FileInputStream(fileToAdd));
                        try {
                            IOUtils.copy((InputStream)input, (OutputStream)archive);
                            archive.closeArchiveEntry();
                        }
                        finally {
                            if (Collections.singletonList(input).get(0) == null) continue;
                            input.close();
                        }
                    }
                    archive.finish();
                }
                finally {
                    if (Collections.singletonList(archive).get(0) != null) {
                        archive.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(archiveStream).get(0) != null) {
                    ((OutputStream)archiveStream).close();
                }
            }
        }
        catch (ArchiveException e) {
            throw new IOException("Issue with creating archive", e);
        }
    }

    private static File[] writeAzkabanConfigFiles(String workDir, String flowName, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        String jobFilePath = String.format("%s/%s.job", workDir, flowName);
        File jobFile = new File(jobFilePath);
        if (jobFile.exists()) {
            if (jobFile.delete()) {
                log.info("JobFile existed and was deleted: " + jobFilePath);
            } else {
                log.warn("JobFile exists but was not deleted: " + jobFilePath);
            }
        }
        StringBuilder propertyFileContent = new StringBuilder();
        for (Map.Entry<Object, Object> entry : azkabanProjectConfig.getJobSpec().getConfigAsProperties().entrySet()) {
            propertyFileContent.append(String.format("%s=%s", entry.getKey(), entry.getValue())).append("\n");
        }
        FileUtils.writeStringToFile((File)jobFile, (String)propertyFileContent.toString(), (Charset)Charset.forName("UTF-8"), (boolean)true);
        return new File[]{jobFile};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Lombok construct of @Cleanup is handing this, but not detected by FindBugs")
    private static File downloadAzkabanJobJar(String workDir, String jobJarUrl) throws IOException {
        String[] jobJarUrlParts = jobJarUrl.trim().split("/");
        String jobJarName = jobJarUrlParts[jobJarUrlParts.length - 1];
        String jobJarFilePath = String.format("%s/%s", workDir, jobJarName);
        File jobJarFile = new File(jobJarFilePath);
        if (jobJarFile.exists()) {
            if (jobJarFile.delete()) {
                log.info("JobJarFilePath existed and was deleted: " + jobJarFilePath);
            } else {
                log.warn("JobJarFilePath exists but was not deleted: " + jobJarFilePath);
            }
        }
        FileUtils.forceMkdir((File)new File(workDir));
        InputStream jobJarInputStream = new URL(jobJarUrl).openStream();
        try {
            File file;
            block11: {
                FileOutputStream jobJarOutputStream = new FileOutputStream(jobJarFile);
                try {
                    IOUtils.copy((InputStream)jobJarInputStream, (OutputStream)jobJarOutputStream);
                    file = jobJarFile;
                    if (Collections.singletonList(jobJarOutputStream).get(0) == null) break block11;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(jobJarOutputStream).get(0) != null) {
                        ((OutputStream)jobJarOutputStream).close();
                    }
                    throw throwable;
                }
                ((OutputStream)jobJarOutputStream).close();
            }
            return file;
        }
        finally {
            if (Collections.singletonList(jobJarInputStream).get(0) != null) {
                jobJarInputStream.close();
            }
        }
    }
}

