/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.InnerMetricContext;
import org.apache.gobblin.metrics.context.ReportableContext;
import org.apache.gobblin.metrics.metric.filter.MetricFilters;
import org.apache.gobblin.metrics.metric.filter.MetricNameRegexFilter;
import org.apache.gobblin.metrics.metric.filter.MetricTypeFilter;
import org.apache.gobblin.metrics.reporter.ContextAwareReporter;
import org.apache.gobblin.util.ExecutorsUtils;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledReporter
extends ContextAwareReporter {
    private static final Logger log = LoggerFactory.getLogger(ScheduledReporter.class);
    public static final String REPORTING_INTERVAL = "metrics.reporting.interval";
    public static final String DEFAULT_REPORTING_INTERVAL_PERIOD = "1M";
    public static final PeriodFormatter PERIOD_FORMATTER = new PeriodFormatterBuilder().appendHours().appendSuffix("H").appendMinutes().appendSuffix("M").appendSeconds().appendSuffix("S").toFormatter();
    private static final String METRIC_FILTER_NAME_REGEX = "metric.filter.name.regex";
    private static final String METRIC_FILTER_TYPE_LIST = "metric.filter.type.list";
    private ScheduledExecutorService executor;
    private MetricFilter metricFilter;
    private Optional<ScheduledFuture> scheduledTask;
    private int reportingPeriodSeconds;

    @VisibleForTesting
    static int parsePeriodToSeconds(String periodStr) {
        try {
            return Period.parse((String)periodStr.toUpperCase(), (PeriodFormatter)PERIOD_FORMATTER).toStandardSeconds().getSeconds();
        }
        catch (ArithmeticException ae) {
            throw new RuntimeException(String.format("Reporting interval is too long. Max: %d seconds.", Integer.MAX_VALUE));
        }
    }

    public static void setReportingInterval(Properties props, long reportingInterval, TimeUnit reportingIntervalUnit) {
        long seconds = TimeUnit.SECONDS.convert(reportingInterval, reportingIntervalUnit);
        if (seconds > Integer.MAX_VALUE) {
            throw new RuntimeException(String.format("Reporting interval is too long. Max: %d seconds.", Integer.MAX_VALUE));
        }
        props.setProperty(REPORTING_INTERVAL, Long.toString(seconds) + "S");
    }

    public static Config setReportingInterval(Config config, long reportingInterval, TimeUnit reportingIntervalUnit) {
        long seconds = TimeUnit.SECONDS.convert(reportingInterval, reportingIntervalUnit);
        if (seconds > Integer.MAX_VALUE) {
            throw new RuntimeException(String.format("Reporting interval is too long. Max: %d seconds.", Integer.MAX_VALUE));
        }
        return config.withValue(REPORTING_INTERVAL, ConfigValueFactory.fromAnyRef((Object)(seconds + "S")));
    }

    public ScheduledReporter(String name, Config config) {
        super(name, config);
        this.ensureMetricFilterIsInitialized(config);
    }

    private synchronized void ensureMetricFilterIsInitialized(Config config) {
        if (this.metricFilter == null) {
            this.metricFilter = this.createMetricFilter(config);
        }
    }

    private MetricFilter createMetricFilter(Config config) {
        if (config.hasPath(METRIC_FILTER_NAME_REGEX) && config.hasPath(METRIC_FILTER_TYPE_LIST)) {
            return MetricFilters.and(new MetricNameRegexFilter(config.getString(METRIC_FILTER_NAME_REGEX)), new MetricTypeFilter(config.getString(METRIC_FILTER_TYPE_LIST)));
        }
        if (config.hasPath(METRIC_FILTER_NAME_REGEX)) {
            return new MetricNameRegexFilter(config.getString(METRIC_FILTER_NAME_REGEX));
        }
        if (config.hasPath(METRIC_FILTER_TYPE_LIST)) {
            return new MetricTypeFilter(config.getString(METRIC_FILTER_TYPE_LIST));
        }
        return MetricFilter.ALL;
    }

    @Override
    public void startImpl() {
        this.executor = Executors.newSingleThreadScheduledExecutor(ExecutorsUtils.newDaemonThreadFactory((Optional)Optional.of((Object)log), (Optional)Optional.of((Object)("metrics-" + this.name + "-scheduler"))));
        this.reportingPeriodSeconds = ScheduledReporter.parsePeriodToSeconds(this.config.hasPath(REPORTING_INTERVAL) ? this.config.getString(REPORTING_INTERVAL) : DEFAULT_REPORTING_INTERVAL_PERIOD);
        this.ensureMetricFilterIsInitialized(this.config);
        this.scheduledTask = Optional.of(this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ScheduledReporter.this.report();
            }
        }, 0L, this.reportingPeriodSeconds, TimeUnit.SECONDS));
    }

    @Override
    public void stopImpl() {
        ((ScheduledFuture)this.scheduledTask.get()).cancel(false);
        this.scheduledTask = Optional.absent();
        ExecutorsUtils.shutdownExecutorService((ExecutorService)this.executor, (Optional)Optional.of((Object)log), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.report(true);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    protected void removedMetricContext(InnerMetricContext context) {
        if (this.shouldReportInnerMetricContext(context)) {
            this.report(context, true);
        }
        super.removedMetricContext(context);
    }

    public void report() {
        this.report(false);
    }

    protected void report(boolean isFinal) {
        for (ReportableContext metricContext : this.getMetricContextsToReport()) {
            this.report(metricContext, isFinal);
        }
    }

    protected final void report(ReportableContext context) {
        this.report(context, false);
    }

    protected void report(ReportableContext context, boolean isFinal) {
        this.report(context.getGauges(this.metricFilter), context.getCounters(this.metricFilter), context.getHistograms(this.metricFilter), context.getMeters(this.metricFilter), context.getTimers(this.metricFilter), context.getTagMap(), isFinal);
    }

    protected void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers, Map<String, Object> tags, boolean isFinal) {
        this.report(gauges, counters, histograms, meters, timers, tags);
    }

    protected abstract void report(SortedMap<String, Gauge> var1, SortedMap<String, Counter> var2, SortedMap<String, Histogram> var3, SortedMap<String, Meter> var4, SortedMap<String, Timer> var5, Map<String, Object> var6);
}

