/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.ContextAwareMetric;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.metric.InnerMetric;

public class InnerTimer
extends Timer
implements InnerMetric {
    private final String name;
    private final Optional<ContextAwareTimer> parentTimer;
    private final WeakReference<ContextAwareTimer> timer;

    InnerTimer(MetricContext context, String name, ContextAwareTimer contextAwareTimer) {
        this.name = name;
        Optional<MetricContext> parentContext = context.getParent();
        this.parentTimer = parentContext.isPresent() ? Optional.fromNullable((Object)((MetricContext)parentContext.get()).contextAwareTimer(name)) : Optional.absent();
        this.timer = new WeakReference<ContextAwareTimer>(contextAwareTimer);
    }

    InnerTimer(MetricContext context, String name, ContextAwareTimer contextAwareTimer, long windowSize, TimeUnit unit) {
        super((Reservoir)new SlidingTimeWindowReservoir(windowSize, unit));
        this.name = name;
        Optional<MetricContext> parentContext = context.getParent();
        this.parentTimer = parentContext.isPresent() ? Optional.fromNullable((Object)((MetricContext)parentContext.get()).contextAwareTimer(name, windowSize, unit)) : Optional.absent();
        this.timer = new WeakReference<ContextAwareTimer>(contextAwareTimer);
    }

    public void update(long duration, TimeUnit unit) {
        super.update(duration, unit);
        if (this.parentTimer.isPresent()) {
            ((ContextAwareTimer)this.parentTimer.get()).update(duration, unit);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ContextAwareMetric getContextAwareMetric() {
        return (ContextAwareMetric)this.timer.get();
    }
}

