/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.Meter;
import com.google.common.base.Optional;
import java.lang.ref.WeakReference;
import org.apache.gobblin.metrics.ContextAwareMeter;
import org.apache.gobblin.metrics.ContextAwareMetric;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.metric.InnerMetric;

public class InnerMeter
extends Meter
implements InnerMetric {
    private final String name;
    private final Optional<ContextAwareMeter> parentMeter;
    private final WeakReference<ContextAwareMeter> contextAwareMeter;

    InnerMeter(MetricContext context, String name, ContextAwareMeter contextAwareMeter) {
        this.name = name;
        Optional<MetricContext> parentContext = context.getParent();
        this.parentMeter = parentContext.isPresent() ? Optional.fromNullable((Object)((MetricContext)parentContext.get()).contextAwareMeter(name)) : Optional.absent();
        this.contextAwareMeter = new WeakReference<ContextAwareMeter>(contextAwareMeter);
    }

    public void mark(long n) {
        super.mark(n);
        if (this.parentMeter.isPresent()) {
            ((ContextAwareMeter)this.parentMeter.get()).mark(n);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ContextAwareMetric getContextAwareMetric() {
        return (ContextAwareMetric)this.contextAwareMeter.get();
    }
}

