/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.Counter;
import com.google.common.base.Optional;
import java.lang.ref.WeakReference;
import org.apache.gobblin.metrics.ContextAwareCounter;
import org.apache.gobblin.metrics.ContextAwareMetric;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tagged;
import org.apache.gobblin.metrics.metric.InnerMetric;

public class InnerCounter
extends Counter
implements InnerMetric {
    protected final String name;
    protected final Tagged tagged = new Tagged();
    protected final Optional<ContextAwareCounter> parentCounter;
    private final WeakReference<ContextAwareCounter> contextAwareCounter;

    public InnerCounter(MetricContext context, String name, ContextAwareCounter counter) {
        this.name = name;
        Optional<MetricContext> parentContext = context.getParent();
        this.parentCounter = parentContext.isPresent() ? Optional.fromNullable((Object)((MetricContext)parentContext.get()).contextAwareCounter(name)) : Optional.absent();
        this.contextAwareCounter = new WeakReference<ContextAwareCounter>(counter);
    }

    public void inc(long n) {
        super.inc(n);
        if (this.parentCounter.isPresent()) {
            ((ContextAwareCounter)this.parentCounter.get()).inc(n);
        }
    }

    public void dec(long n) {
        super.dec(n);
        if (this.parentCounter.isPresent()) {
            ((ContextAwareCounter)this.parentCounter.get()).dec(n);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ContextAwareMetric getContextAwareMetric() {
        return (ContextAwareMetric)this.contextAwareCounter.get();
    }
}

