/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client.response;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.client.response.BatchKVResponse;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.EntityResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.TypeSpec;
import java.util.HashSet;
import java.util.Map;

public class BatchEntityResponse<K, E extends RecordTemplate>
extends BatchKVResponse<K, EntityResponse<E>> {
    private final TypeSpec<E> _entityType;

    public BatchEntityResponse(DataMap data, TypeSpec<K> keyType, TypeSpec<E> entityType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType, ProtocolVersion version) {
        super(data);
        this._entityType = entityType;
        this.createSchema(this.getEntityResponseValueClass());
        this.deserializeData(keyType, keyParts, complexKeyType, version);
    }

    @Override
    protected void deserializeData(TypeSpec<K> keyType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType, ProtocolVersion version) {
        DataMap dataMap = this.data();
        DataMap convertedData = new DataMap();
        DataMap mergedResults = new DataMap();
        DataMap inputResults = dataMap.containsKey((Object)"results") ? dataMap.getDataMap("results") : new DataMap();
        DataMap inputStatuses = dataMap.containsKey((Object)"statuses") ? dataMap.getDataMap("statuses") : new DataMap();
        DataMap inputErrors = dataMap.containsKey((Object)"errors") ? dataMap.getDataMap("errors") : new DataMap();
        HashSet mergedKeys = new HashSet(inputResults.keySet());
        mergedKeys.addAll(inputStatuses.keySet());
        mergedKeys.addAll(inputErrors.keySet());
        for (String key : mergedKeys) {
            Object errorData;
            Object statusData;
            DataMap entityResponseData = new DataMap();
            Object entityData = inputResults.get((Object)key);
            if (entityData != null) {
                CheckedUtil.putWithoutChecking((CheckedMap)entityResponseData, (Object)"entity", (Object)entityData);
            }
            if ((statusData = inputStatuses.get((Object)key)) != null) {
                CheckedUtil.putWithoutChecking((CheckedMap)entityResponseData, (Object)"status", (Object)statusData);
            }
            if ((errorData = inputErrors.get((Object)key)) != null) {
                CheckedUtil.putWithoutChecking((CheckedMap)entityResponseData, (Object)"error", (Object)errorData);
            }
            CheckedUtil.putWithoutChecking((CheckedMap)mergedResults, (Object)key, (Object)entityResponseData);
        }
        CheckedUtil.putWithoutChecking((CheckedMap)convertedData, (Object)"results", (Object)mergedResults);
        CheckedUtil.putWithoutChecking((CheckedMap)convertedData, (Object)"errors", (Object)inputErrors);
        super.deserializeData(convertedData, keyType, keyParts, complexKeyType, version);
    }

    @Override
    protected EntityResponse<E> deserializeValue(Object valueData) {
        return new EntityResponse((DataMap)valueData, this._entityType.getType());
    }

    private Class<EntityResponse<E>> getEntityResponseValueClass() {
        Class<EntityResponse> valueClass = EntityResponse.class;
        return valueClass;
    }
}

