/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.restli.common.OptionsResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.internal.client.RestResponseDecoder;
import com.linkedin.restli.restspec.ResourceSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OptionsResponseDecoder
extends RestResponseDecoder<OptionsResponse> {
    public static final String RESOURCES = "resources";
    public static final String MODELS = "models";
    private static final JacksonDataCodec CODEC = new JacksonDataCodec();

    @Override
    public OptionsResponse wrapResponse(DataMap dataMap, Map<String, String> headers, ProtocolVersion version) throws IOException {
        if (dataMap == null) {
            return null;
        }
        DataMap resources = dataMap.getDataMap(RESOURCES);
        if (resources == null) {
            resources = new DataMap();
        }
        HashMap resourceMap = new HashMap(resources.size());
        for (Map.Entry entry : resources.entrySet()) {
            resourceMap.put(entry.getKey(), new ResourceSchema((DataMap)entry.getValue()));
        }
        DataMap schemas = dataMap.getDataMap(MODELS);
        if (schemas == null) {
            schemas = new DataMap();
        }
        HashMap dataSchemaMap = new HashMap(schemas.size());
        for (Map.Entry entry : schemas.entrySet()) {
            String schemaText = CODEC.mapToString((DataMap)entry.getValue());
            dataSchemaMap.put(entry.getKey(), DataTemplateUtil.parseSchema((String)schemaText));
        }
        return new OptionsResponse(resourceMap, dataSchemaMap);
    }

    @Override
    public Class<?> getEntityClass() {
        return OptionsResponse.class;
    }
}

