/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.RestLiDecodingException;
import com.linkedin.restli.client.RestLiResponseException;
import com.linkedin.restli.common.ErrorResponse;
import com.linkedin.restli.internal.client.EntityResponseDecoder;
import com.linkedin.restli.internal.client.RestResponseDecoder;
import com.linkedin.restli.internal.common.HeaderUtil;
import java.util.Map;

public class ExceptionUtil {
    private static final EntityResponseDecoder<ErrorResponse> ERROR_DECODER = new EntityResponseDecoder<ErrorResponse>(ErrorResponse.class);

    private ExceptionUtil() {
    }

    public static RemoteInvocationException exceptionForThrowable(Throwable e, RestResponseDecoder<?> responseDecoder) {
        if (e instanceof RestException) {
            ErrorResponse errorResponse;
            RestException re = (RestException)e;
            RestResponse response = re.getResponse();
            try {
                errorResponse = ExceptionUtil.getErrorResponse(response);
            }
            catch (RestLiDecodingException decodingException) {
                return new RemoteInvocationException(e.getMessage(), (Throwable)((Object)decodingException));
            }
            Response<?> decodedResponse = null;
            String header = HeaderUtil.getErrorResponseHeaderValue((Map)response.getHeaders());
            if (header == null) {
                try {
                    decodedResponse = responseDecoder.decodeResponse(response);
                }
                catch (RestLiDecodingException decodingException) {
                    return new RemoteInvocationException(e.getMessage(), e);
                }
            }
            return new RestLiResponseException(response, decodedResponse, errorResponse, e);
        }
        if (e instanceof RemoteInvocationException) {
            return (RemoteInvocationException)e;
        }
        return new RemoteInvocationException(e);
    }

    static RemoteInvocationException wrapThrowable(Throwable e) {
        if (e instanceof RestLiResponseException) {
            ErrorResponse errorResponse;
            RestLiResponseException restliException = (RestLiResponseException)((Object)e);
            try {
                errorResponse = ExceptionUtil.getErrorResponse(restliException.getResponse());
            }
            catch (RestLiDecodingException decodingException) {
                return new RemoteInvocationException((Throwable)((Object)decodingException));
            }
            return new RestLiResponseException(restliException.getResponse(), restliException.getDecodedResponse(), errorResponse, (Throwable)((Object)restliException));
        }
        return new RemoteInvocationException(e);
    }

    private static ErrorResponse getErrorResponse(RestResponse response) throws RestLiDecodingException {
        ErrorResponse errorResponse = null;
        String header = HeaderUtil.getErrorResponseHeaderValue((Map)response.getHeaders());
        if (header != null) {
            errorResponse = (ErrorResponse)ERROR_DECODER.decodeResponse(response).getEntity();
        }
        if (errorResponse == null) {
            errorResponse = new ErrorResponse();
        }
        return errorResponse;
    }
}

