/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.BatchRequest;
import com.linkedin.restli.common.CollectionRequest;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.KeyValueRecord;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.URIParamUtils;
import java.util.Map;

public class CollectionRequestUtil {
    public static <V extends RecordTemplate> BatchRequest<V> convertToBatchRequest(CollectionRequest<KeyValueRecord> elementList, TypeSpec<?> keyType, ComplexKeySpec<?, ?> complexKeyType, Map<String, CompoundKey.TypeInfo> keyParts, TypeSpec<V> valueType) {
        return CollectionRequestUtil.convertToBatchRequest(elementList, keyType, complexKeyType, keyParts, valueType, AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion());
    }

    public static <V extends RecordTemplate> BatchRequest<V> convertToBatchRequest(CollectionRequest<KeyValueRecord> elementList, Class<?> keyClass, Class<? extends RecordTemplate> keyKeyClass, Class<? extends RecordTemplate> keyParamsClass, Map<String, CompoundKey.TypeInfo> keyParts, Class<V> valueClass, ProtocolVersion version) {
        return CollectionRequestUtil.convertToBatchRequest(elementList, TypeSpec.forClassMaybeNull(keyClass), ComplexKeySpec.forClassesMaybeNull(keyKeyClass, keyParamsClass), keyParts, TypeSpec.forClassMaybeNull(valueClass), version);
    }

    public static <V extends RecordTemplate> BatchRequest<V> convertToBatchRequest(CollectionRequest<KeyValueRecord> elementList, TypeSpec<?> keyType, ComplexKeySpec<?, ?> complexKeyType, Map<String, CompoundKey.TypeInfo> keyParts, TypeSpec<V> valueType, ProtocolVersion version) {
        BatchRequest batchRequest = new BatchRequest(new DataMap(), valueType);
        for (KeyValueRecord keyValueRecord : elementList.getElements()) {
            RecordTemplate value = keyValueRecord.getValue(valueType);
            Object key = null;
            if (keyType != null) {
                key = keyType.getType().equals(ComplexResourceKey.class) ? keyValueRecord.getComplexKey(complexKeyType) : (CompoundKey.class.isAssignableFrom(keyType.getType()) ? keyValueRecord.getCompoundKey(keyParts) : keyValueRecord.getPrimitiveKey(keyType));
            }
            batchRequest.getEntities().put(URIParamUtils.encodeKeyForBody(key, (boolean)true, (ProtocolVersion)version), value);
        }
        return batchRequest;
    }
}

