/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.gobblin.data.management.version.FileStatusAware;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.hadoop.fs.FileStatus;
import org.joda.time.DateTime;

public class FileStatusTimestampedDatasetVersion
extends TimestampedDatasetVersion
implements FileStatusAware {
    private final FileStatus fileStatus;

    public FileStatusTimestampedDatasetVersion(DateTime version, FileStatus fileStatus) {
        super(version, fileStatus.getPath());
        this.fileStatus = fileStatus;
    }

    @Override
    public Set<FileStatus> getFileStatuses() {
        return Sets.newHashSet((Object[])new FileStatus[]{this.fileStatus});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileStatusTimestampedDatasetVersion)) {
            return false;
        }
        FileStatusTimestampedDatasetVersion other = (FileStatusTimestampedDatasetVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileStatus this$fileStatus = this.fileStatus;
        FileStatus other$fileStatus = other.fileStatus;
        return !(this$fileStatus == null ? other$fileStatus != null : !this$fileStatus.equals(other$fileStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileStatusTimestampedDatasetVersion;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        FileStatus $fileStatus = this.fileStatus;
        result = result * 59 + ($fileStatus == null ? 43 : $fileStatus.hashCode());
        return result;
    }
}

