/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.profile;

import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.ConfigClientCache;
import org.apache.gobblin.config.client.api.ConfigStoreFactoryDoesNotExistsException;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.config.store.api.ConfigStoreCreationException;
import org.apache.gobblin.config.store.api.VersionDoesNotExistException;
import org.apache.gobblin.data.management.retention.dataset.ConfigurableCleanableDataset;
import org.apache.gobblin.data.management.retention.profile.ConfigurableGlobDatasetFinder;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.LoggerFactory;

public class ManagedCleanableDatasetFinder
extends ConfigurableGlobDatasetFinder<ConfigurableCleanableDataset<FileSystemDatasetVersion>> {
    private final ConfigClient client;

    public ManagedCleanableDatasetFinder(FileSystem fs, Properties jobProps, Config config) {
        this(fs, jobProps, config, ConfigClientCache.getClient((VersionStabilityPolicy)VersionStabilityPolicy.STRONG_LOCAL_STABILITY));
    }

    public ManagedCleanableDatasetFinder(FileSystem fs, Properties jobProps, Config config, ConfigClient client) {
        super(fs, jobProps, config);
        this.client = client;
    }

    @Override
    public ConfigurableCleanableDataset<FileSystemDatasetVersion> datasetAtPath(Path path) throws IOException {
        try {
            return new ConfigurableCleanableDataset<FileSystemDatasetVersion>(this.fs, this.props, path, this.client.getConfig(this.props.getProperty("gobblin.config.management.store.uri") + path.toString()), LoggerFactory.getLogger(ConfigurableCleanableDataset.class));
        }
        catch (URISyntaxException | ConfigStoreFactoryDoesNotExistsException | ConfigStoreCreationException | VersionDoesNotExistException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

