/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.HiveFileSet;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HivePartitionsDeregisterFileSet
extends HiveFileSet {
    private static final Logger log = LoggerFactory.getLogger(HivePartitionsDeregisterFileSet.class);
    private final Collection<Partition> partitionsToDeregister;
    private final HiveCopyEntityHelper helper;

    public HivePartitionsDeregisterFileSet(String name, HiveDataset dataset, Collection<Partition> partitionsToDeregister, HiveCopyEntityHelper helper) {
        super(name, dataset);
        this.partitionsToDeregister = partitionsToDeregister;
        this.helper = helper;
    }

    @Override
    protected Collection<CopyEntity> generateCopyEntities() throws IOException {
        ArrayList deregisterCopyEntities = Lists.newArrayList();
        int priority = 1;
        for (Partition partition : this.partitionsToDeregister) {
            try {
                priority = this.helper.addPartitionDeregisterSteps(deregisterCopyEntities, this.getName(), priority, this.helper.getTargetTable(), partition);
            }
            catch (IOException ioe) {
                log.error("Could not create work unit to deregister partition " + partition.getCompleteName());
            }
        }
        return deregisterCopyEntities;
    }
}

