/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.RecursiveCopyableDataset;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class TimeAwareRecursiveCopyableDataset
extends RecursiveCopyableDataset {
    private static final String CONFIG_PREFIX = "gobblin.copy.recursive";
    public static final String DATE_PATTERN_KEY = "gobblin.copy.recursive.date.pattern";
    public static final String LOOKBACK_DAYS_KEY = "gobblin.copy.recursive.lookback.days";
    private final Integer lookbackDays;
    private final String datePattern;

    public TimeAwareRecursiveCopyableDataset(FileSystem fs, Path rootPath, Properties properties, Path glob) {
        super(fs, rootPath, properties, glob);
        this.lookbackDays = Integer.parseInt(properties.getProperty(LOOKBACK_DAYS_KEY));
        this.datePattern = properties.getProperty(DATE_PATTERN_KEY);
    }

    @Override
    protected List<FileStatus> getFilesAtPath(FileSystem fs, Path path, PathFilter fileFilter) throws IOException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.datePattern);
        LocalDateTime endDate = LocalDateTime.now();
        LocalDateTime startDate = endDate.minusDays(this.lookbackDays.intValue());
        DateRangeIterator dateRangeIterator = new DateRangeIterator(startDate, endDate, this.datePattern);
        ArrayList fileStatuses = Lists.newArrayList();
        while (dateRangeIterator.hasNext()) {
            Path pathWithDateTime = new Path(path, dateRangeIterator.next().format(formatter));
            fileStatuses.addAll(super.getFilesAtPath(fs, pathWithDateTime, fileFilter));
        }
        return fileStatuses;
    }

    public static class DateRangeIterator
    implements Iterator {
        private LocalDateTime startDate;
        private LocalDateTime endDate;
        private boolean isDatePatternHourly;

        public DateRangeIterator(LocalDateTime startDate, LocalDateTime endDate, String datePattern) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.isDatePatternHourly = this.isDatePatternHourly(datePattern);
        }

        private boolean isDatePatternHourly(String datePattern) {
            LocalDateTime refDateTimeAtStartOfDay;
            String refDateTimeStringAtStartOfDay;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
            LocalDateTime refDateTime = LocalDateTime.of(2017, 1, 1, 10, 0, 0);
            String refDateTimeString = refDateTime.format(formatter);
            return !refDateTimeString.equals(refDateTimeStringAtStartOfDay = (refDateTimeAtStartOfDay = refDateTime.withHour(0)).format(formatter));
        }

        @Override
        public boolean hasNext() {
            return !this.startDate.isAfter(this.endDate);
        }

        public LocalDateTime next() {
            LocalDateTime dateTime = this.startDate;
            this.startDate = this.isDatePatternHourly ? this.startDate.plusHours(1L) : this.startDate.plusDays(1L);
            return dateTime;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

