/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.query;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDataset;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.Partition;

public class HiveValidationQueryGenerator {
    public static List<String> generateCountValidationQueries(HiveDataset hiveDataset, Optional<Partition> sourcePartition, ConvertibleHiveDataset.ConversionConfig conversionConfig) {
        String sourceDatabase = hiveDataset.getDbAndTable().getDb();
        String sourceTable = hiveDataset.getDbAndTable().getTable();
        String destinationDatabase = conversionConfig.getDestinationDbName();
        String destinationTable = conversionConfig.getDestinationTableName();
        ArrayList queries = Lists.newArrayList();
        if (sourcePartition.isPresent()) {
            StringBuilder partitionClause = new StringBuilder();
            boolean isFirst = true;
            String partitionInfo = ((Partition)sourcePartition.get()).getName();
            List pInfo = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)partitionInfo);
            for (String aPInfo : pInfo) {
                List pInfoParts = Splitter.on((String)"=").omitEmptyStrings().trimResults().splitToList((CharSequence)aPInfo);
                if (pInfoParts.size() != 2) {
                    throw new IllegalArgumentException(String.format("Partition details should be of the format partitionName=partitionValue. Recieved: %s", aPInfo));
                }
                if (isFirst) {
                    isFirst = false;
                } else {
                    partitionClause.append(" and ");
                }
                partitionClause.append("`").append((String)pInfoParts.get(0)).append("`='").append((String)pInfoParts.get(1)).append("'");
            }
            queries.add(String.format("SELECT count(*) FROM `%s`.`%s` WHERE %s ", sourceDatabase, sourceTable, partitionClause));
            queries.add(String.format("SELECT count(*) FROM `%s`.`%s` WHERE %s ", destinationDatabase, destinationTable, partitionClause));
        } else {
            queries.add(String.format("SELECT count(*) FROM `%s`.`%s` ", sourceDatabase, sourceTable));
            queries.add(String.format("SELECT count(*) FROM `%s`.`%s` ", destinationDatabase, destinationTable));
        }
        return queries;
    }

    public static String generateDataValidationQuery(String sourceTable, String sourceDb, Table targetTable, Optional<Partition> optionalPartition, boolean isNestedORC) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(*) FROM `").append(sourceDb).append("`.`").append(sourceTable).append("` s JOIN `").append(targetTable.getDbName()).append("`.`").append(targetTable.getTableName()).append("` t ON \n");
        boolean isFirst = true;
        List fieldList = targetTable.getSd().getCols();
        for (FieldSchema field : fieldList) {
            if (StringUtils.startsWithIgnoreCase((CharSequence)field.getType(), (CharSequence)"map") || StringUtils.containsIgnoreCase((CharSequence)field.getType(), (CharSequence)":map")) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(" AND \n");
            }
            if (isNestedORC) {
                sb.append("\ts.`").append(field.getName()).append("`<=>");
            } else {
                String colName = field.getComment().replaceAll("from flatten_source ", "").trim();
                sb.append("\ts.`").append(colName.replaceAll("\\.", "`.`")).append("`<=>");
            }
            sb.append("t.`").append(field.getName()).append("` ");
        }
        sb.append("\n");
        if (optionalPartition.isPresent()) {
            Partition partition = (Partition)optionalPartition.get();
            String partitionsInfoString = partition.getName();
            List pInfo = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)partitionsInfoString);
            for (int i = 0; i < pInfo.size(); ++i) {
                List partitionInfoParts = Splitter.on((String)"=").omitEmptyStrings().trimResults().splitToList((CharSequence)pInfo.get(i));
                if (partitionInfoParts.size() != 2) {
                    throw new IllegalArgumentException(String.format("Partition details should be of the format partitionName=partitionValue. Recieved: %s", pInfo.get(i)));
                }
                if (i == 0) {
                    sb.append(" WHERE \n");
                } else {
                    sb.append(" AND ");
                }
                sb.append(String.format("s.`%s`='%s' ", partitionInfoParts.get(0), partitionInfoParts.get(1)));
                sb.append(" AND ");
                sb.append(String.format("t.`%s`='%s' ", partitionInfoParts.get(0), partitionInfoParts.get(1)));
            }
        }
        return sb.toString();
    }
}

