/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.materializer;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHivePublishEntity;
import org.apache.gobblin.data.management.conversion.hive.entities.StageableTableMetadata;
import org.apache.gobblin.data.management.conversion.hive.materializer.HiveMaterializer;
import org.apache.gobblin.data.management.conversion.hive.source.HiveSource;
import org.apache.gobblin.data.management.conversion.hive.source.HiveWorkUnit;
import org.apache.gobblin.data.management.conversion.hive.task.HiveConverterUtils;
import org.apache.gobblin.data.management.conversion.hive.task.QueryGenerator;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveMaterializerQueryGenerator
implements QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(HiveMaterializerQueryGenerator.class);
    protected final FileSystem fs;
    protected final StageableTableMetadata outputTableMetadata;
    protected final String outputDatabaseName;
    protected final String outputTableName;
    protected final String outputDataLocation;
    protected final String stagingTableName;
    protected final String stagingDataLocation;
    protected final Optional<Table> destinationTableMeta;
    protected final HiveWorkUnit workUnit;
    protected final HiveMetastoreClientPool pool;
    protected final WorkUnitState workUnitState;

    public HiveMaterializerQueryGenerator(WorkUnitState workUnitState) throws IOException {
        this.fs = HiveSource.getSourceFs((State)workUnitState);
        this.pool = HiveMetastoreClientPool.get((Properties)workUnitState.getJobState().getProperties(), (Optional)Optional.fromNullable((Object)workUnitState.getJobState().getProp("hive.dataset.hive.metastore.uri")));
        this.workUnitState = workUnitState;
        this.workUnit = new HiveWorkUnit(workUnitState.getWorkunit());
        this.outputTableMetadata = HiveMaterializer.parseStageableTableMetadata(this.workUnit);
        this.outputDatabaseName = this.outputTableMetadata.getDestinationDbName();
        this.outputTableName = this.outputTableMetadata.getDestinationTableName();
        this.outputDataLocation = HiveConverterUtils.getOutputDataLocation(this.outputTableMetadata.getDestinationDataPath());
        this.destinationTableMeta = (Optional)HiveConverterUtils.getDestinationTableMeta(this.outputTableMetadata.getDestinationDbName(), this.outputTableMetadata.getDestinationTableName(), workUnitState.getProperties()).getLeft();
        this.stagingTableName = HiveConverterUtils.getStagingTableName(this.outputTableMetadata.getDestinationStagingTableName());
        this.stagingDataLocation = HiveConverterUtils.getStagingDataLocation(this.outputTableMetadata.getDestinationDataPath(), this.stagingTableName);
    }

    @Override
    public abstract List<String> generateQueries();

    protected void ensureParentOfStagingPathExists() {
        try {
            Path parentStagingPath = new Path(this.stagingDataLocation).getParent();
            if (!this.fs.exists(parentStagingPath)) {
                this.fs.mkdirs(parentStagingPath);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public abstract QueryBasedHivePublishEntity generatePublishQueries() throws DataConversionException;
}

