/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression.streaming;

import com.linkedin.common.callback.Callback;
import com.linkedin.data.ByteString;
import com.linkedin.r2.filter.compression.streaming.ByteStringsWriter;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import java.util.LinkedList;
import java.util.Queue;

public class PartialReader
implements Reader {
    private final int _numBytes;
    private final Callback<EntityStream[]> _callback;
    private final Queue<ByteString> _buffer = new LinkedList<ByteString>();
    private ReadHandle _rh;
    private WriteHandle _remainingWh;
    private int _readLen;
    private int _outstanding;

    public PartialReader(int numBytes, Callback<EntityStream[]> callback) {
        this._numBytes = numBytes;
        this._callback = callback;
        this._readLen = 0;
    }

    public void onInit(ReadHandle rh) {
        this._rh = rh;
        this._rh.request(1);
    }

    public void onDataAvailable(ByteString data) {
        if (this._remainingWh == null) {
            this._buffer.add(data);
            this._readLen += data.length();
            if (this._readLen <= this._numBytes) {
                this._rh.request(1);
            } else {
                EntityStream stream = EntityStreams.newEntityStream((Writer)new ByteStringsWriter(this._buffer));
                EntityStream remaining = EntityStreams.newEntityStream((Writer)new RemainingWriter());
                this._callback.onSuccess((Object)new EntityStream[]{stream, remaining});
            }
        } else {
            --this._outstanding;
            this._remainingWh.write(data);
            int diff = this._remainingWh.remaining() - this._outstanding;
            if (diff > 0) {
                this._rh.request(diff);
                this._outstanding += diff;
            }
        }
    }

    public void onDone() {
        if (this._remainingWh == null) {
            EntityStream stream = EntityStreams.newEntityStream((Writer)new ByteStringsWriter(this._buffer));
            this._callback.onSuccess((Object)new EntityStream[]{stream});
        } else {
            this._remainingWh.done();
        }
    }

    public void onError(Throwable e) {
        if (this._remainingWh == null) {
            this._callback.onError(e);
        } else {
            this._remainingWh.error(e);
        }
    }

    private class RemainingWriter
    implements Writer {
        private RemainingWriter() {
        }

        public void onInit(WriteHandle wh) {
            PartialReader.this._remainingWh = wh;
        }

        public void onWritePossible() {
            PartialReader.this._outstanding = PartialReader.this._remainingWh.remaining();
            PartialReader.this._rh.request(PartialReader.this._outstanding);
        }

        public void onAbort(Throwable e) {
        }
    }
}

