/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression.streaming;

import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.streaming.StreamEncodingType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AcceptEncoding
implements Comparable<AcceptEncoding> {
    private final StreamEncodingType _type;
    private final float _quality;

    public AcceptEncoding(StreamEncodingType type, float quality) {
        this._type = type;
        this._quality = quality;
    }

    public float getQuality() {
        return this._quality;
    }

    public StreamEncodingType getType() {
        return this._type;
    }

    public static StreamEncodingType[] parseAcceptEncoding(String acceptCompression) {
        if (acceptCompression.trim().isEmpty()) {
            return new StreamEncodingType[0];
        }
        String[] entries = acceptCompression.toLowerCase().split(",");
        StreamEncodingType[] types = new StreamEncodingType[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            StreamEncodingType type = StreamEncodingType.get(entries[i].trim());
            if (type == null) {
                throw new IllegalArgumentException(entries[i].trim() + " is not supported");
            }
            types[i] = type;
        }
        return types;
    }

    public static List<AcceptEncoding> parseAcceptEncodingHeader(String headerValue, Set<StreamEncodingType> supportedEncodings) throws CompressionException {
        headerValue = headerValue.toLowerCase();
        String[] entries = headerValue.split(",");
        ArrayList<AcceptEncoding> parsedEncodings = new ArrayList<AcceptEncoding>();
        for (String entry : entries) {
            String[] content = entry.trim().split(";");
            if (content.length < 1 || content.length > 2) {
                throw new IllegalArgumentException("Illegal format in Accept-Encoding: " + entry);
            }
            StreamEncodingType type = StreamEncodingType.get(content[0].trim());
            Float quality = Float.valueOf(1.0f);
            if (type == null || !supportedEncodings.contains((Object)type)) continue;
            if (content.length > 1) {
                String acceptEncodingPart = content[1].trim();
                if (acceptEncodingPart.startsWith("q=")) {
                    try {
                        quality = Float.valueOf(Float.parseFloat(acceptEncodingPart.substring("q=".length())));
                    }
                    catch (NumberFormatException e) {
                        throw new CompressionException("Illegal format in Accept-Encoding: " + entry, e);
                    }
                } else {
                    throw new CompressionException("Illegal format in Accept-Encoding: " + entry);
                }
            }
            parsedEncodings.add(new AcceptEncoding(type, quality.floatValue()));
        }
        return parsedEncodings;
    }

    public static StreamEncodingType chooseBest(List<AcceptEncoding> entries) {
        Collections.sort(entries);
        HashSet<StreamEncodingType> bannedEncoding = new HashSet<StreamEncodingType>();
        for (int lastEntry = entries.size() - 1; lastEntry >= 0 && (double)entries.get(lastEntry).getQuality() <= 0.0; --lastEntry) {
            AcceptEncoding removed = entries.remove(lastEntry);
            bannedEncoding.add(removed.getType());
        }
        for (AcceptEncoding type : entries) {
            if (type.getType() == StreamEncodingType.ANY) {
                if (bannedEncoding.contains((Object)StreamEncodingType.IDENTITY)) continue;
                return StreamEncodingType.IDENTITY;
            }
            return type.getType();
        }
        return bannedEncoding.contains((Object)StreamEncodingType.ANY) || bannedEncoding.contains((Object)StreamEncodingType.IDENTITY) ? null : StreamEncodingType.IDENTITY;
    }

    @Override
    public int compareTo(AcceptEncoding target) {
        return new Float(target.getQuality()).compareTo(Float.valueOf(this.getQuality()));
    }
}

