/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.CompressionConfig;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.compression.AcceptEncoding;
import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.Compressor;
import com.linkedin.r2.filter.compression.EncodingType;
import com.linkedin.r2.filter.compression.ServerCompressionHelper;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.message.MessageHeaders;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCompressionFilter
implements RestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ServerCompressionFilter.class);
    private final Set<EncodingType> _supportedEncoding;
    private final ServerCompressionHelper _serverCompressionHelper;
    private static final String EMPTY = "";

    public ServerCompressionFilter() {
        this(EMPTY);
    }

    public ServerCompressionFilter(String acceptedFilters) {
        this(acceptedFilters, new CompressionConfig(Integer.MAX_VALUE));
    }

    public ServerCompressionFilter(String acceptedFilters, CompressionConfig responseCompressionConfig) {
        this(AcceptEncoding.parseAcceptEncoding(acceptedFilters), responseCompressionConfig);
    }

    public ServerCompressionFilter(EncodingType[] supportedEncoding, CompressionConfig defaultResponseCompressionConfig) {
        if (defaultResponseCompressionConfig == null) {
            throw new IllegalArgumentException("Compression config should not be null.");
        }
        this._supportedEncoding = new HashSet<EncodingType>(Arrays.asList(supportedEncoding));
        this._supportedEncoding.add(EncodingType.IDENTITY);
        this._supportedEncoding.add(EncodingType.ANY);
        this._serverCompressionHelper = new ServerCompressionHelper(defaultResponseCompressionConfig);
    }

    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        try {
            String responseAcceptedEncodings;
            String requestContentEncoding = req.getHeader("Content-Encoding");
            if (requestContentEncoding != null) {
                EncodingType encoding;
                try {
                    encoding = EncodingType.get(requestContentEncoding.trim().toLowerCase());
                }
                catch (IllegalArgumentException ex) {
                    throw new CompressionException("Unsupported encoding referenced: " + requestContentEncoding);
                }
                if (encoding == EncodingType.ANY) {
                    throw new CompressionException("ANY may not be used as request encoding type: " + requestContentEncoding);
                }
                if (encoding.hasCompressor()) {
                    byte[] decompressedContent = encoding.getCompressor().inflate(req.getEntity().asInputStream());
                    HashMap<String, String> headers = new HashMap<String, String>(req.getHeaders());
                    headers.remove("Content-Encoding");
                    headers.put("Content-Length", Integer.toString(decompressedContent.length));
                    req = ((RestRequestBuilder)req.builder().setEntity(decompressedContent).setHeaders(headers)).build();
                }
            }
            if ((responseAcceptedEncodings = req.getHeader("Accept-Encoding")) == null) {
                responseAcceptedEncodings = EMPTY;
            }
            requestContext.putLocalAttr("Accept-Encoding", (Object)responseAcceptedEncodings);
            if (!responseAcceptedEncodings.isEmpty()) {
                requestContext.putLocalAttr("X-Response-Compression-Threshold", (Object)this._serverCompressionHelper.getResponseCompressionThreshold((MessageHeaders)req));
            }
            nextFilter.onRequest((Request)req, requestContext, wireAttrs);
        }
        catch (CompressionException e) {
            LOG.error(e.getMessage(), e.getCause());
            RestResponse restResponse = ((RestResponseBuilder)new RestResponseBuilder().setStatus(415)).build();
            nextFilter.onError((Throwable)new RestException(restResponse, (Throwable)e), requestContext, wireAttrs);
        }
    }

    public void onRestResponse(RestResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        try {
            if (res.getEntity().length() > 0) {
                String responseAcceptedEncodings = (String)requestContext.getLocalAttr("Accept-Encoding");
                if (responseAcceptedEncodings == null) {
                    throw new CompressionException("Accept-Encoding not in local attribute.");
                }
                List<AcceptEncoding> parsedEncodings = AcceptEncoding.parseAcceptEncodingHeader(responseAcceptedEncodings, this._supportedEncoding);
                EncodingType selectedEncoding = AcceptEncoding.chooseBest(parsedEncodings);
                if (selectedEncoding != null) {
                    Compressor compressor;
                    byte[] compressed;
                    if (selectedEncoding.hasCompressor() && res.getEntity().length() > (Integer)requestContext.getLocalAttr("X-Response-Compression-Threshold") && (compressed = (compressor = selectedEncoding.getCompressor()).deflate(res.getEntity().asInputStream())).length < res.getEntity().length()) {
                        RestResponseBuilder resCompress = res.builder();
                        resCompress.addHeaderValue("Content-Encoding", compressor.getContentEncodingName());
                        resCompress.setEntity(compressed);
                        res = resCompress.build();
                    }
                } else {
                    res = ((RestResponseBuilder)res.builder().setStatus(406)).setEntity(new byte[0]).build();
                }
            }
        }
        catch (CompressionException e) {
            LOG.error(e.getMessage(), e.getCause());
        }
        nextFilter.onResponse((Response)res, requestContext, wireAttrs);
    }

    public void onRestError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        nextFilter.onError(ex, requestContext, wireAttrs);
    }
}

