/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.compression.Bzip2Compressor;
import com.linkedin.r2.filter.compression.Compressor;
import com.linkedin.r2.filter.compression.DeflateCompressor;
import com.linkedin.r2.filter.compression.GzipCompressor;
import com.linkedin.r2.filter.compression.SnappyCompressor;
import com.linkedin.r2.filter.compression.SnappyFramedCompressor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum EncodingType {
    GZIP(new GzipCompressor()),
    DEFLATE(new DeflateCompressor()),
    BZIP2(new Bzip2Compressor()),
    SNAPPY(new SnappyCompressor()),
    SNAPPY_FRAMED(new SnappyFramedCompressor()),
    IDENTITY("identity"),
    ANY("*");

    private final String httpName;
    private final Compressor compressor;
    private static final Map<String, EncodingType> _reverseMap;

    private EncodingType(String httpName) {
        this.httpName = httpName;
        this.compressor = null;
    }

    private EncodingType(Compressor compressor) {
        this.compressor = compressor;
        this.httpName = compressor.getContentEncodingName();
    }

    public String getHttpName() {
        return this.httpName;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public static EncodingType get(String compressionHeader) {
        EncodingType result = _reverseMap.get(compressionHeader);
        if (result == null) {
            throw new IllegalArgumentException("Unsupported encoding referenced: " + compressionHeader);
        }
        return result;
    }

    public static boolean isSupported(String encodingName) {
        return _reverseMap.containsKey(encodingName);
    }

    public boolean hasCompressor() {
        return this.getCompressor() != null;
    }

    static {
        HashMap<String, EncodingType> reverseMap = new HashMap<String, EncodingType>();
        for (EncodingType t : EncodingType.values()) {
            reverseMap.put(t.getHttpName(), t);
        }
        _reverseMap = Collections.unmodifiableMap(reverseMap);
    }
}

