/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.filter.CompressionConfig;
import com.linkedin.r2.filter.CompressionOption;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.compression.ClientCompressionHelper;
import com.linkedin.r2.filter.compression.streaming.AcceptEncoding;
import com.linkedin.r2.filter.compression.streaming.PartialReader;
import com.linkedin.r2.filter.compression.streaming.StreamEncodingType;
import com.linkedin.r2.filter.compression.streaming.StreamingCompressor;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.stream.StreamException;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.message.stream.entitystream.CompositeWriter;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.Writer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStreamCompressionFilter
implements StreamFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientStreamCompressionFilter.class);
    private final StreamEncodingType _requestContentEncoding;
    private final CompressionConfig _requestCompressionConfig;
    private final CompressionConfig _responseCompressionConfig;
    private final StreamEncodingType[] _acceptedEncodings;
    private final String _acceptEncodingHeader;
    private final ClientCompressionHelper _helper;
    private final Executor _executor;

    public ClientStreamCompressionFilter(StreamEncodingType requestContentEncoding, CompressionConfig requestCompressionConfig, StreamEncodingType[] acceptedEncodings, CompressionConfig responseCompressionConfig, List<String> responseCompressionOperations, Executor executor) {
        if (requestContentEncoding == null) {
            throw new IllegalArgumentException("Request compression encoding must be valid non-null, use \"identity\"/EncodingType.IDENTITY for no compression.");
        }
        if (acceptedEncodings == null) {
            acceptedEncodings = new StreamEncodingType[]{};
        }
        for (StreamEncodingType type : acceptedEncodings) {
            if (type != null) continue;
            throw new IllegalArgumentException("Request compression encoding must be valid non-null, use \"identity\"/EncodingType.IDENTITY for no compression.");
        }
        if (requestContentEncoding.equals((Object)StreamEncodingType.ANY)) {
            throw new IllegalArgumentException("ANY may not be used as request encoding type: " + requestContentEncoding.getHttpName());
        }
        this._requestContentEncoding = requestContentEncoding;
        this._requestCompressionConfig = requestCompressionConfig;
        this._acceptedEncodings = acceptedEncodings;
        this._responseCompressionConfig = responseCompressionConfig;
        this._acceptEncodingHeader = this.buildAcceptEncodingHeader();
        this._helper = new ClientCompressionHelper(requestCompressionConfig, responseCompressionOperations);
        this._executor = executor;
    }

    public ClientStreamCompressionFilter(String requestContentEncoding, CompressionConfig requestCompressionConfig, String acceptedEncodings, CompressionConfig responseCompressionConfig, List<String> responseCompressionOperations, Executor executor) {
        this(requestContentEncoding.trim().isEmpty() ? StreamEncodingType.IDENTITY : StreamEncodingType.get(requestContentEncoding.trim().toLowerCase()), requestCompressionConfig, AcceptEncoding.parseAcceptEncoding(acceptedEncodings), responseCompressionConfig, responseCompressionOperations, executor);
    }

    public String buildAcceptEncodingHeader() {
        float delta = 1.0f / (float)(this._acceptedEncodings.length + 1);
        float currentQuality = 1.0f;
        StringBuilder acceptEncodingValue = new StringBuilder();
        for (int i = 0; i < this._acceptedEncodings.length; ++i) {
            StreamEncodingType t = this._acceptedEncodings[i];
            if (i > 0) {
                acceptEncodingValue.append(",");
            }
            acceptEncodingValue.append(t.getHttpName());
            acceptEncodingValue.append(";");
            acceptEncodingValue.append("q=");
            acceptEncodingValue.append(String.format("%.2f", Float.valueOf(currentQuality)));
            currentQuality -= delta;
        }
        return acceptEncodingValue.toString();
    }

    public void onStreamRequest(StreamRequest req, final RequestContext requestContext, final Map<String, String> wireAttrs, final NextFilter<StreamRequest, StreamResponse> nextFilter) {
        String operation = (String)requestContext.getLocalAttr("OPERATION");
        if (!this._acceptEncodingHeader.isEmpty() && this._helper.shouldCompressResponseForOperation(operation)) {
            CompressionOption responseCompressionOverride = (CompressionOption)requestContext.getLocalAttr("RESPONSE_COMPRESSION_OVERRIDE");
            req = this.addResponseCompressionHeaders(responseCompressionOverride, req);
        }
        if (this._requestContentEncoding != StreamEncodingType.IDENTITY) {
            final StreamRequest request = req;
            final StreamingCompressor compressor = this._requestContentEncoding.getCompressor(this._executor);
            CompressionOption option = (CompressionOption)requestContext.getLocalAttr("REQUEST_COMPRESSION_OVERRIDE");
            if (option == null || option != CompressionOption.FORCE_OFF) {
                int threshold = option == CompressionOption.FORCE_ON ? 0 : this._requestCompressionConfig.getCompressionThreshold();
                PartialReader reader = new PartialReader(threshold, new Callback<EntityStream[]>(){

                    public void onError(Throwable ex) {
                        nextFilter.onError(ex, requestContext, wireAttrs);
                    }

                    public void onSuccess(EntityStream[] result) {
                        if (result.length == 1) {
                            StreamRequest uncompressedRequest = request.builder().build(result[0]);
                            nextFilter.onRequest((Request)uncompressedRequest, requestContext, wireAttrs);
                        } else {
                            StreamRequestBuilder builder = request.builder();
                            EntityStream compressedStream = compressor.deflate(EntityStreams.newEntityStream((Writer)new CompositeWriter(result)));
                            Map headers = ClientStreamCompressionFilter.this.stripHeaders(builder.getHeaders(), new String[]{"Content-Length"});
                            StreamRequest compressedRequest = ((StreamRequestBuilder)((StreamRequestBuilder)builder.setHeaders(headers)).setHeader("Content-Encoding", compressor.getContentEncodingName())).build(compressedStream);
                            nextFilter.onRequest((Request)compressedRequest, requestContext, wireAttrs);
                        }
                    }
                });
                req.getEntityStream().setReader((Reader)reader);
                return;
            }
        }
        nextFilter.onRequest((Request)req, requestContext, wireAttrs);
    }

    public void onStreamResponse(StreamResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        String compressionHeader;
        Boolean decompressionOff = (Boolean)requestContext.getLocalAttr("RESPONSE_DECOMPRESSION_OFF");
        if (!(decompressionOff != null && decompressionOff.booleanValue() || (compressionHeader = res.getHeader("Content-Encoding")) == null)) {
            StreamEncodingType encoding = StreamEncodingType.get(compressionHeader.trim().toLowerCase());
            if (encoding == null) {
                nextFilter.onError((Throwable)new IllegalArgumentException("Server returned unrecognized content encoding: " + compressionHeader), requestContext, wireAttrs);
                return;
            }
            StreamingCompressor compressor = encoding.getCompressor(this._executor);
            EntityStream uncompressedStream = compressor.inflate(res.getEntityStream());
            StreamResponseBuilder builder = res.builder();
            Map<String, String> headers = this.stripHeaders(builder.getHeaders(), "Content-Encoding", "Content-Length");
            res = ((StreamResponseBuilder)builder.setHeaders(headers)).build(uncompressedStream);
        }
        nextFilter.onResponse((Response)res, requestContext, wireAttrs);
    }

    public void onStreamError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        StreamEncodingType encoding;
        StreamException se;
        StreamResponse response;
        String compressionHeader;
        Boolean decompressionOff;
        if (ex instanceof StreamException && ((decompressionOff = (Boolean)requestContext.getLocalAttr("RESPONSE_DECOMPRESSION_OFF")) == null || !decompressionOff.booleanValue()) && (compressionHeader = (response = (se = (StreamException)ex).getResponse()).getHeader("Content-Encoding")) != null && (encoding = StreamEncodingType.get(compressionHeader.trim().toLowerCase())) != null) {
            StreamingCompressor compressor = encoding.getCompressor(this._executor);
            EntityStream uncompressedStream = compressor.inflate(response.getEntityStream());
            StreamResponseBuilder builder = response.builder();
            Map<String, String> headers = this.stripHeaders(builder.getHeaders(), "Content-Encoding", "Content-Length");
            response = ((StreamResponseBuilder)builder.setHeaders(headers)).build(uncompressedStream);
            ex = new StreamException(response);
        }
        nextFilter.onError(ex, requestContext, wireAttrs);
    }

    private Map<String, String> stripHeaders(Map<String, String> headerMap, String ... headers) {
        TreeMap<String, String> newMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        newMap.putAll(headerMap);
        for (String header : headers) {
            newMap.remove(header);
        }
        return newMap;
    }

    public StreamRequest addResponseCompressionHeaders(CompressionOption responseCompressionOverride, StreamRequest req) {
        StreamRequestBuilder builder = req.builder();
        if (responseCompressionOverride == null) {
            builder.addHeaderValue("Accept-Encoding", this._acceptEncodingHeader);
            if (this._responseCompressionConfig != null) {
                builder.addHeaderValue("X-Response-Compression-Threshold", Integer.toString(this._responseCompressionConfig.getCompressionThreshold()));
            }
        } else if (responseCompressionOverride == CompressionOption.FORCE_ON) {
            ((StreamRequestBuilder)builder.addHeaderValue("Accept-Encoding", this._acceptEncodingHeader)).addHeaderValue("X-Response-Compression-Threshold", Integer.toString(0));
        }
        return builder.build(req.getEntityStream());
    }
}

