/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.callback;

import com.linkedin.common.callback.Callback;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class FutureCallback<T>
implements Future<T>,
Callback<T> {
    private final AtomicReference<Result<T>> _result = new AtomicReference();
    private final CountDownLatch _doneLatch = new CountDownLatch(1);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this._doneLatch.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this._doneLatch.await();
        return this.unwrapResult();
    }

    private T getRaw() throws Throwable {
        this._doneLatch.await();
        return this.unwrapResultRaw();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this._doneLatch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.unwrapResult();
    }

    private T getRaw(long timeout, TimeUnit unit) throws Throwable {
        if (!this._doneLatch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.unwrapResultRaw();
    }

    @Override
    public void onSuccess(T t) {
        this.safeSetValue(Result.createSuccess(t));
        this._doneLatch.countDown();
    }

    @Override
    public void onError(Throwable e) {
        Throwable error = e != null ? e : new NullPointerException("Null error is passed to onError!");
        this.safeSetValue(Result.createError(error));
        this._doneLatch.countDown();
    }

    private void safeSetValue(Result<T> result) {
        assert (result != null);
        if (!this._result.compareAndSet(null, result)) {
            throw new IllegalStateException("Callback already invoked. Value will not be changed. Proposed value: " + result.getValue() + ". Original value: " + this._result.get().getValue());
        }
    }

    private T unwrapResult() throws ExecutionException {
        try {
            return this.unwrapResultRaw();
        }
        catch (Throwable e) {
            throw new ExecutionException(e);
        }
    }

    private T unwrapResultRaw() throws Throwable {
        Result<T> result = this._result.get();
        assert (result != null);
        if (result.isSuccess()) {
            return result.getResult();
        }
        throw result.getError();
    }

    private static final class Result<T> {
        private final boolean _isSuccess;
        private final T _result;
        private final Throwable _ex;

        public static <T> Result<T> createSuccess(T t) {
            return new Result<T>(t, null, true);
        }

        public static <T> Result<T> createError(Throwable e) {
            return new Result<Object>(null, e, false);
        }

        private Result(T result, Throwable ex, boolean isSuccess) {
            this._result = result;
            this._ex = ex;
            this._isSuccess = isSuccess;
        }

        public T getResult() {
            return this._result;
        }

        public Throwable getError() {
            return this._ex;
        }

        public boolean isSuccess() {
            return this._isSuccess;
        }

        public Object getValue() {
            return this.isSuccess() ? this._result : this._ex;
        }
    }
}

