/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;

public class RelMdPopulationSize {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.POPULATION_SIZE.method, new RelMdPopulationSize());

    private RelMdPopulationSize() {
    }

    public Double getPopulationSize(Filter rel, ImmutableBitSet groupKey) {
        return RelMetadataQuery.getPopulationSize(rel.getInput(), groupKey);
    }

    public Double getPopulationSize(Sort rel, ImmutableBitSet groupKey) {
        return RelMetadataQuery.getPopulationSize(rel.getInput(), groupKey);
    }

    public Double getPopulationSize(Exchange rel, ImmutableBitSet groupKey) {
        return RelMetadataQuery.getPopulationSize(rel.getInput(), groupKey);
    }

    public Double getPopulationSize(Union rel, ImmutableBitSet groupKey) {
        Double population = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double subPop = RelMetadataQuery.getPopulationSize(input, groupKey);
            if (subPop == null) {
                return null;
            }
            population = population + subPop;
        }
        return population;
    }

    public Double getPopulationSize(Join rel, ImmutableBitSet groupKey) {
        return RelMdUtil.getJoinPopulationSize(rel, groupKey);
    }

    public Double getPopulationSize(SemiJoin rel, ImmutableBitSet groupKey) {
        return RelMetadataQuery.getPopulationSize(rel.getLeft(), groupKey);
    }

    public Double getPopulationSize(Aggregate rel, ImmutableBitSet groupKey) {
        ImmutableBitSet.Builder childKey = ImmutableBitSet.builder();
        RelMdUtil.setAggChildKeys(groupKey, rel, childKey);
        return RelMetadataQuery.getPopulationSize(rel.getInput(), childKey.build());
    }

    public Double getPopulationSize(Values rel, ImmutableBitSet groupKey) {
        return rel.getRows() / 2.0;
    }

    public Double getPopulationSize(Project rel, ImmutableBitSet groupKey) {
        ImmutableBitSet.Builder baseCols = ImmutableBitSet.builder();
        ImmutableBitSet.Builder projCols = ImmutableBitSet.builder();
        List<RexNode> projExprs = rel.getProjects();
        RelMdUtil.splitCols(projExprs, groupKey, baseCols, projCols);
        Double population = RelMetadataQuery.getPopulationSize(rel.getInput(), baseCols.build());
        if (population == null) {
            return null;
        }
        if (projCols.cardinality() == 0) {
            return population;
        }
        for (int bit : projCols.build()) {
            Double subRowCount = RelMdUtil.cardOfProjExpr(rel, projExprs.get(bit));
            if (subRowCount == null) {
                return null;
            }
            population = population * subRowCount;
        }
        return RelMdUtil.numDistinctVals(population, RelMetadataQuery.getRowCount(rel));
    }

    public Double getPopulationSize(RelNode rel, ImmutableBitSet groupKey) {
        boolean uniq = RelMdUtil.areColumnsDefinitelyUnique(rel, groupKey);
        if (uniq) {
            return RelMetadataQuery.getRowCount(rel);
        }
        return null;
    }
}

