/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.multipart;

import com.linkedin.multipart.MultiPartMIMEUtils;
import com.linkedin.multipart.MultiPartMIMEWriter;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class MultiPartMIMEStreamResponseFactory {
    public static StreamResponse generateMultiPartMIMEStreamResponse(String mimeSubType, MultiPartMIMEWriter writer) {
        return MultiPartMIMEStreamResponseFactory.generateMultiPartMIMEStreamResponse(mimeSubType, writer, Collections.emptyMap(), new StreamResponseBuilder());
    }

    public static StreamResponse generateMultiPartMIMEStreamResponse(String mimeSubType, MultiPartMIMEWriter writer, Map<String, String> contentTypeParameters) {
        return MultiPartMIMEStreamResponseFactory.generateMultiPartMIMEStreamResponse(mimeSubType, writer, contentTypeParameters, new StreamResponseBuilder());
    }

    public static StreamResponse generateMultiPartMIMEStreamResponse(String mimeSubType, MultiPartMIMEWriter writer, Map<String, String> contentTypeParameters, Map<String, String> headers, int status, List<String> cookies) {
        return MultiPartMIMEStreamResponseFactory.generateMultiPartMIMEStreamResponse(mimeSubType, writer, contentTypeParameters, (StreamResponseBuilder)((StreamResponseBuilder)((StreamResponseBuilder)new StreamResponseBuilder().setHeaders(headers)).setStatus(status)).setCookies(cookies));
    }

    private static StreamResponse generateMultiPartMIMEStreamResponse(String mimeSubType, MultiPartMIMEWriter writer, Map<String, String> contentTypeParameters, StreamResponseBuilder streamResponseBuilder) {
        String contentTypeHeader = MultiPartMIMEUtils.buildMIMEContentTypeHeader(mimeSubType.trim(), writer.getBoundary(), contentTypeParameters);
        streamResponseBuilder.setHeader("Content-Type", contentTypeHeader);
        return streamResponseBuilder.build(writer.getEntityStream());
    }

    private MultiPartMIMEStreamResponseFactory() {
    }
}

