/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.multipart;

import com.linkedin.multipart.MultiPartMIMEUtils;
import com.linkedin.multipart.MultiPartMIMEWriter;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class MultiPartMIMEStreamRequestFactory {
    public static StreamRequest generateMultiPartMIMEStreamRequest(URI uri, String mimeSubType, MultiPartMIMEWriter writer) {
        return MultiPartMIMEStreamRequestFactory.generateMultiPartMIMEStreamRequest(mimeSubType, writer, Collections.emptyMap(), (StreamRequestBuilder)new StreamRequestBuilder(uri).setMethod("POST"));
    }

    public static StreamRequest generateMultiPartMIMEStreamRequest(URI uri, String mimeSubType, MultiPartMIMEWriter writer, Map<String, String> contentTypeParameters) {
        return MultiPartMIMEStreamRequestFactory.generateMultiPartMIMEStreamRequest(mimeSubType, writer, contentTypeParameters, new StreamRequestBuilder(uri));
    }

    public static StreamRequest generateMultiPartMIMEStreamRequest(URI uri, String mimeSubType, MultiPartMIMEWriter writer, Map<String, String> contentTypeParameters, String method, Map<String, String> headers, List<String> cookies) {
        return MultiPartMIMEStreamRequestFactory.generateMultiPartMIMEStreamRequest(mimeSubType, writer, contentTypeParameters, (StreamRequestBuilder)((StreamRequestBuilder)((StreamRequestBuilder)new StreamRequestBuilder(uri).setHeaders(headers)).setMethod(method)).setCookies(cookies));
    }

    private static StreamRequest generateMultiPartMIMEStreamRequest(String mimeSubType, MultiPartMIMEWriter writer, Map<String, String> contentTypeParameters, StreamRequestBuilder streamRequestBuilder) {
        String contentTypeHeader = MultiPartMIMEUtils.buildMIMEContentTypeHeader(mimeSubType.trim(), writer.getBoundary(), contentTypeParameters);
        streamRequestBuilder.setHeader("Content-Type", contentTypeHeader);
        return streamRequestBuilder.build(writer.getEntityStream());
    }

    private MultiPartMIMEStreamRequestFactory() {
    }
}

