/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;

public class JobStatistics
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"JobStatistics\",\"namespace\":\"org.apache.gobblin.service\",\"doc\":\"Statistics from a job execution\",\"fields\":[{\"name\":\"executionStartTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution began\"},{\"name\":\"executionEndTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution ended\"},{\"name\":\"processedCount\",\"type\":\"long\",\"doc\":\"number of records processed in the last job execution\"}]}");
    private static final RecordDataSchema.Field FIELD_ExecutionStartTime = SCHEMA.getField("executionStartTime");
    private static final RecordDataSchema.Field FIELD_ExecutionEndTime = SCHEMA.getField("executionEndTime");
    private static final RecordDataSchema.Field FIELD_ProcessedCount = SCHEMA.getField("processedCount");

    public JobStatistics() {
        super(new DataMap(), SCHEMA);
    }

    public JobStatistics(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasExecutionStartTime() {
        return this.contains(FIELD_ExecutionStartTime);
    }

    public void removeExecutionStartTime() {
        this.remove(FIELD_ExecutionStartTime);
    }

    public Long getExecutionStartTime(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_ExecutionStartTime, Long.class, mode);
    }

    @Nonnull
    public Long getExecutionStartTime() {
        return (Long)this.obtainDirect(FIELD_ExecutionStartTime, Long.class, GetMode.STRICT);
    }

    public JobStatistics setExecutionStartTime(Long value, SetMode mode) {
        this.putDirect(FIELD_ExecutionStartTime, Long.class, Long.class, value, mode);
        return this;
    }

    public JobStatistics setExecutionStartTime(@Nonnull Long value) {
        this.putDirect(FIELD_ExecutionStartTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobStatistics setExecutionStartTime(long value) {
        this.putDirect(FIELD_ExecutionStartTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasExecutionEndTime() {
        return this.contains(FIELD_ExecutionEndTime);
    }

    public void removeExecutionEndTime() {
        this.remove(FIELD_ExecutionEndTime);
    }

    public Long getExecutionEndTime(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_ExecutionEndTime, Long.class, mode);
    }

    @Nonnull
    public Long getExecutionEndTime() {
        return (Long)this.obtainDirect(FIELD_ExecutionEndTime, Long.class, GetMode.STRICT);
    }

    public JobStatistics setExecutionEndTime(Long value, SetMode mode) {
        this.putDirect(FIELD_ExecutionEndTime, Long.class, Long.class, value, mode);
        return this;
    }

    public JobStatistics setExecutionEndTime(@Nonnull Long value) {
        this.putDirect(FIELD_ExecutionEndTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobStatistics setExecutionEndTime(long value) {
        this.putDirect(FIELD_ExecutionEndTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasProcessedCount() {
        return this.contains(FIELD_ProcessedCount);
    }

    public void removeProcessedCount() {
        this.remove(FIELD_ProcessedCount);
    }

    public Long getProcessedCount(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_ProcessedCount, Long.class, mode);
    }

    @Nonnull
    public Long getProcessedCount() {
        return (Long)this.obtainDirect(FIELD_ProcessedCount, Long.class, GetMode.STRICT);
    }

    public JobStatistics setProcessedCount(Long value, SetMode mode) {
        this.putDirect(FIELD_ProcessedCount, Long.class, Long.class, value, mode);
        return this;
    }

    public JobStatistics setProcessedCount(@Nonnull Long value) {
        this.putDirect(FIELD_ProcessedCount, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobStatistics setProcessedCount(long value) {
        this.putDirect(FIELD_ProcessedCount, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobStatistics clone() throws CloneNotSupportedException {
        return (JobStatistics)super.clone();
    }

    public JobStatistics copy() throws CloneNotSupportedException {
        return (JobStatistics)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec executionStartTime() {
            return new PathSpec(this.getPathComponents(), "executionStartTime");
        }

        public PathSpec executionEndTime() {
            return new PathSpec(this.getPathComponents(), "executionEndTime");
        }

        public PathSpec processedCount() {
            return new PathSpec(this.getPathComponents(), "processedCount");
        }
    }
}

