/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.gobblin.service.FlowId;
import org.apache.gobblin.service.Schedule;

public class FlowConfig
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"FlowConfig\",\"namespace\":\"org.apache.gobblin.service\",\"doc\":\"Defines a flow configuration that can be compiled into Gobblin jobs\",\"fields\":[{\"name\":\"id\",\"type\":{\"type\":\"record\",\"name\":\"FlowId\",\"doc\":\"Identifier for a Gobblin as a Service flow\",\"fields\":[{\"name\":\"flowName\",\"type\":\"string\",\"doc\":\"Name of the flow\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}},{\"name\":\"flowGroup\",\"type\":\"string\",\"doc\":\"Group of the flow. This defines the namespace for the flow.\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}}]},\"doc\":\"Identifier for the flow\"},{\"name\":\"schedule\",\"type\":{\"type\":\"record\",\"name\":\"Schedule\",\"doc\":\"Attributes for defining a job schedule\",\"fields\":[{\"name\":\"cronSchedule\",\"type\":\"string\",\"doc\":\"Schedule for flow in cron format\",\"validate\":{\"org.apache.gobblin.service.validator.CronValidator\":{}}},{\"name\":\"runImmediately\",\"type\":\"boolean\",\"doc\":\"Set to true to request that a job with a schedule be run immediately in addition to being scheduled\",\"default\":false}]},\"doc\":\"Optional schedule for when to execution the flow. If a schedule is not specified then the flow is executed immediately.\",\"optional\":true},{\"name\":\"templateUris\",\"type\":\"string\",\"doc\":\"Comma separated list of URIs for templates used in the flow. The template location is defined by the multiproduct that packages the template.\",\"validate\":{\"org.apache.gobblin.service.validator.TemplateUriValidator\":{}}},{\"name\":\"properties\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Properties for the flow. These properties are passed to the compiled Gobblin jobs.\"}]}");
    private static final RecordDataSchema.Field FIELD_Id = SCHEMA.getField("id");
    private static final RecordDataSchema.Field FIELD_Schedule = SCHEMA.getField("schedule");
    private static final RecordDataSchema.Field FIELD_TemplateUris = SCHEMA.getField("templateUris");
    private static final RecordDataSchema.Field FIELD_Properties = SCHEMA.getField("properties");

    public FlowConfig() {
        super(new DataMap(), SCHEMA);
    }

    public FlowConfig(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasId() {
        return this.contains(FIELD_Id);
    }

    public void removeId() {
        this.remove(FIELD_Id);
    }

    public FlowId getId(GetMode mode) {
        return (FlowId)this.obtainWrapped(FIELD_Id, FlowId.class, mode);
    }

    @Nonnull
    public FlowId getId() {
        return (FlowId)this.obtainWrapped(FIELD_Id, FlowId.class, GetMode.STRICT);
    }

    public FlowConfig setId(FlowId value, SetMode mode) {
        this.putWrapped(FIELD_Id, FlowId.class, (DataTemplate)value, mode);
        return this;
    }

    public FlowConfig setId(@Nonnull FlowId value) {
        this.putWrapped(FIELD_Id, FlowId.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasSchedule() {
        return this.contains(FIELD_Schedule);
    }

    public void removeSchedule() {
        this.remove(FIELD_Schedule);
    }

    public Schedule getSchedule(GetMode mode) {
        return (Schedule)this.obtainWrapped(FIELD_Schedule, Schedule.class, mode);
    }

    @Nullable
    public Schedule getSchedule() {
        return (Schedule)this.obtainWrapped(FIELD_Schedule, Schedule.class, GetMode.STRICT);
    }

    public FlowConfig setSchedule(Schedule value, SetMode mode) {
        this.putWrapped(FIELD_Schedule, Schedule.class, (DataTemplate)value, mode);
        return this;
    }

    public FlowConfig setSchedule(@Nonnull Schedule value) {
        this.putWrapped(FIELD_Schedule, Schedule.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasTemplateUris() {
        return this.contains(FIELD_TemplateUris);
    }

    public void removeTemplateUris() {
        this.remove(FIELD_TemplateUris);
    }

    public String getTemplateUris(GetMode mode) {
        return (String)this.obtainDirect(FIELD_TemplateUris, String.class, mode);
    }

    @Nonnull
    public String getTemplateUris() {
        return (String)this.obtainDirect(FIELD_TemplateUris, String.class, GetMode.STRICT);
    }

    public FlowConfig setTemplateUris(String value, SetMode mode) {
        this.putDirect(FIELD_TemplateUris, String.class, String.class, value, mode);
        return this;
    }

    public FlowConfig setTemplateUris(@Nonnull String value) {
        this.putDirect(FIELD_TemplateUris, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasProperties() {
        return this.contains(FIELD_Properties);
    }

    public void removeProperties() {
        this.remove(FIELD_Properties);
    }

    public StringMap getProperties(GetMode mode) {
        return (StringMap)this.obtainWrapped(FIELD_Properties, StringMap.class, mode);
    }

    @Nonnull
    public StringMap getProperties() {
        return (StringMap)this.obtainWrapped(FIELD_Properties, StringMap.class, GetMode.STRICT);
    }

    public FlowConfig setProperties(StringMap value, SetMode mode) {
        this.putWrapped(FIELD_Properties, StringMap.class, (DataTemplate)value, mode);
        return this;
    }

    public FlowConfig setProperties(@Nonnull StringMap value) {
        this.putWrapped(FIELD_Properties, StringMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public FlowConfig clone() throws CloneNotSupportedException {
        return (FlowConfig)super.clone();
    }

    public FlowConfig copy() throws CloneNotSupportedException {
        return (FlowConfig)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FlowId.Fields id() {
            return new FlowId.Fields(this.getPathComponents(), "id");
        }

        public Schedule.Fields schedule() {
            return new Schedule.Fields(this.getPathComponents(), "schedule");
        }

        public PathSpec templateUris() {
            return new PathSpec(this.getPathComponents(), "templateUris");
        }

        public PathSpec properties() {
            return new PathSpec(this.getPathComponents(), "properties");
        }
    }
}

