/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.PropertyType;
import org.apache.log4j.Logger;

public final class HelixUtil {
    private static Logger LOG = Logger.getLogger(HelixUtil.class);

    private HelixUtil() {
    }

    public static String getInstanceNameFromPath(String path) {
        String[] split;
        if (path.contains("/" + (Object)((Object)PropertyType.INSTANCES) + "/") && (split = path.split("\\/")).length > 3) {
            return split[3];
        }
        return null;
    }

    public static String getZkParentPath(String path) {
        if (path.equals("/")) {
            return null;
        }
        int idx = path.lastIndexOf(47);
        return idx == 0 ? "/" : path.substring(0, idx);
    }

    public static String getZkName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String serializeByComma(List<String> objects) {
        return Joiner.on((String)",").join(objects);
    }

    public static List<String> deserializeByComma(String object) {
        if (object.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(object.split(","));
    }

    public static Map<String, String> parseCsvFormatedKeyValuePairs(String keyValuePairs) {
        String[] pairs = keyValuePairs.split("[\\s,]");
        TreeMap<String, String> keyValueMap = new TreeMap<String, String>();
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                LOG.error((Object)("Invalid key-value pair: " + pair + ". Igonore it."));
                continue;
            }
            String key = pair.substring(0, idx);
            String value = pair.substring(idx + 1);
            keyValueMap.put(key, value);
        }
        return keyValueMap;
    }

    public static <T> Class<?> loadClass(Class<T> clazz, String className) throws ClassNotFoundException {
        try {
            return clazz.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            throw ex;
        }
    }
}

