/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.task.TaskUtil;

public abstract class UserContentStore {
    private HelixManager _manager;
    private String _workflowName;
    private String _jobName;
    private String _taskName;

    public void init(HelixManager manager, String workflowName, String jobName, String taskName) {
        this._manager = manager;
        this._workflowName = workflowName;
        this._jobName = jobName;
        this._taskName = taskName;
    }

    public void putUserContent(String key, String value, Scope scope) {
        switch (scope) {
            case WORKFLOW: {
                TaskUtil.addWorkflowJobUserContent(this._manager, this._workflowName, key, value);
                break;
            }
            case JOB: {
                TaskUtil.addWorkflowJobUserContent(this._manager, this._jobName, key, value);
                break;
            }
            case TASK: {
                TaskUtil.addTaskUserContent(this._manager, this._jobName, this._taskName, key, value);
                break;
            }
            default: {
                throw new HelixException("Invalid scope : " + scope.name());
            }
        }
    }

    public String getUserContent(String key, Scope scope) {
        switch (scope) {
            case WORKFLOW: {
                return TaskUtil.getWorkflowJobUserContent(this._manager, this._workflowName, key);
            }
            case JOB: {
                return TaskUtil.getWorkflowJobUserContent(this._manager, this._jobName, key);
            }
            case TASK: {
                return TaskUtil.getTaskUserContent(this._manager, this._jobName, this._taskName, key);
            }
        }
        throw new HelixException("Invalid scope : " + scope.name());
    }

    protected static enum Scope {
        WORKFLOW,
        JOB,
        TASK;

    }
}

