/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskAssignmentCalculator;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.log4j.Logger;

public class FixedTargetTaskAssignmentCalculator
extends TaskAssignmentCalculator {
    private static final Logger LOG = Logger.getLogger(FixedTargetTaskAssignmentCalculator.class);

    @Override
    public Set<Integer> getAllTaskPartitions(JobConfig jobCfg, JobContext jobCtx, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Map<String, IdealState> idealStateMap) {
        return FixedTargetTaskAssignmentCalculator.getAllTaskPartitions(FixedTargetTaskAssignmentCalculator.getTgtIdealState(jobCfg, idealStateMap), jobCfg, jobCtx);
    }

    @Override
    public Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput currStateOutput, ResourceAssignment prevAssignment, Collection<String> instances, JobConfig jobCfg, JobContext jobContext, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Set<Integer> partitionSet, Map<String, IdealState> idealStateMap) {
        IdealState tgtIs = FixedTargetTaskAssignmentCalculator.getTgtIdealState(jobCfg, idealStateMap);
        if (tgtIs == null) {
            LOG.warn((Object)"Missing target resource for the scheduled job!");
            return Collections.emptyMap();
        }
        Set<String> tgtStates = jobCfg.getTargetPartitionStates();
        return FixedTargetTaskAssignmentCalculator.getTgtPartitionAssignment(currStateOutput, instances, tgtIs, tgtStates, partitionSet, jobContext);
    }

    private static IdealState getTgtIdealState(JobConfig jobCfg, Map<String, IdealState> idealStateMap) {
        String tgtResourceId = jobCfg.getTargetResource();
        return idealStateMap.get(tgtResourceId);
    }

    private static Set<Integer> getAllTaskPartitions(IdealState tgtResourceIs, JobConfig jobCfg, JobContext taskCtx) {
        Map<String, List<Integer>> currentTargets = taskCtx.getPartitionsByTarget();
        TreeSet targetPartitions = Sets.newTreeSet();
        if (jobCfg.getTargetPartitions() != null) {
            targetPartitions.addAll(jobCfg.getTargetPartitions());
        } else if (tgtResourceIs != null) {
            targetPartitions.addAll(tgtResourceIs.getPartitionSet());
        } else {
            LOG.warn((Object)"Missing target resource for the scheduled job!");
        }
        TreeSet taskPartitions = Sets.newTreeSet();
        for (String pName : targetPartitions) {
            taskPartitions.addAll(FixedTargetTaskAssignmentCalculator.getPartitionsForTargetPartition(pName, currentTargets, taskCtx));
        }
        return taskPartitions;
    }

    private static List<Integer> getPartitionsForTargetPartition(String targetPartition, Map<String, List<Integer>> currentTargets, JobContext jobCtx) {
        if (!currentTargets.containsKey(targetPartition)) {
            int nextId = jobCtx.getPartitionSet().size();
            jobCtx.setPartitionTarget(nextId, targetPartition);
            return Lists.newArrayList((Object[])new Integer[]{nextId});
        }
        return currentTargets.get(targetPartition);
    }

    private static Map<String, SortedSet<Integer>> getTgtPartitionAssignment(CurrentStateOutput currStateOutput, Iterable<String> instances, IdealState tgtIs, Set<String> tgtStates, Set<Integer> includeSet, JobContext jobCtx) {
        HashMap<String, SortedSet<Integer>> result = new HashMap<String, SortedSet<Integer>>();
        for (String instance : instances) {
            result.put(instance, new TreeSet());
        }
        Map<String, List<Integer>> partitionsByTarget = jobCtx.getPartitionsByTarget();
        for (String pName : tgtIs.getPartitionSet()) {
            int pId;
            List<Integer> partitions = partitionsByTarget.get(pName);
            if (partitions == null || partitions.size() < 1 || !includeSet.contains(pId = partitions.get(0).intValue())) continue;
            for (String instance : instances) {
                String s;
                Message pendingMessage = currStateOutput.getPendingState(tgtIs.getResourceName(), new Partition(pName), instance);
                if (pendingMessage != null || (s = currStateOutput.getCurrentState(tgtIs.getResourceName(), new Partition(pName), instance)) == null || tgtStates != null && !tgtStates.contains(s)) continue;
                ((SortedSet)result.get(instance)).add(pId);
            }
        }
        return result;
    }
}

