/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.helix.model.Partition;
import org.apache.log4j.Logger;

public class Resource {
    private static Logger LOG = Logger.getLogger(Resource.class);
    private final String _resourceName;
    private final Map<String, Partition> _partitionMap;
    private String _stateModelDefRef;
    private String _stateModelFactoryName;
    private int _bucketSize = 0;
    private boolean _batchMessageMode = false;
    private String _resourceGroupName;
    private String _resourceTag;

    public Resource(String resourceName) {
        this._resourceName = resourceName;
        this._partitionMap = new LinkedHashMap<String, Partition>();
    }

    public String getStateModelDefRef() {
        return this._stateModelDefRef;
    }

    public void setStateModelDefRef(String stateModelDefRef) {
        this._stateModelDefRef = stateModelDefRef;
    }

    public void setStateModelFactoryName(String factoryName) {
        this._stateModelFactoryName = factoryName == null ? "DEFAULT" : factoryName;
    }

    public String getStateModelFactoryname() {
        return this._stateModelFactoryName;
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public Collection<Partition> getPartitions() {
        return this._partitionMap.values();
    }

    public void addPartition(String partitionName) {
        this._partitionMap.put(partitionName, new Partition(partitionName));
    }

    public Partition getPartition(String partitionName) {
        return this._partitionMap.get(partitionName);
    }

    public int getBucketSize() {
        return this._bucketSize;
    }

    public void setBucketSize(int bucketSize) {
        this._bucketSize = bucketSize;
    }

    public void setBatchMessageMode(boolean mode) {
        this._batchMessageMode = mode;
    }

    public boolean getBatchMessageMode() {
        return this._batchMessageMode;
    }

    public String getResourceTag() {
        return this._resourceTag;
    }

    public void setResourceTag(String resourceTag) {
        this._resourceTag = resourceTag;
    }

    public String getResourceGroupName() {
        return this._resourceGroupName;
    }

    public void setResourceGroupName(String resourceGroupName) {
        this._resourceGroupName = resourceGroupName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("resourceName:").append(this._resourceName);
        sb.append(", stateModelDef:").append(this._stateModelDefRef);
        sb.append(", bucketSize:").append(this._bucketSize);
        sb.append(", partitionStateMap:").append(this._partitionMap);
        return sb.toString();
    }
}

