/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.util.HelixUtil;
import org.apache.log4j.Logger;

public class InstanceConfig
extends HelixProperty {
    public static final int WEIGHT_NOT_SET = -1;
    public static final int MAX_CONCURRENT_TASK_NOT_SET = -1;
    private static final Logger _logger = Logger.getLogger((String)InstanceConfig.class.getName());

    public InstanceConfig(String instanceId) {
        super(instanceId);
    }

    public InstanceConfig(ZNRecord record) {
        super(record);
    }

    public String getHostName() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_HOST.toString());
    }

    public void setHostName(String hostName) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_HOST.toString(), hostName);
    }

    public String getPort() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_PORT.toString());
    }

    public void setPort(String port) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_PORT.toString(), port);
    }

    @Deprecated
    public String getZoneId() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_ZONE_ID.name());
    }

    public void setZoneId(String zoneId) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_ZONE_ID.name(), zoneId);
    }

    public String getDomain() {
        return this._record.getSimpleField(InstanceConfigProperty.DOMAIN.name());
    }

    public void setDomain(String domain) {
        this._record.setSimpleField(InstanceConfigProperty.DOMAIN.name(), domain);
    }

    public int getWeight() {
        String w = this._record.getSimpleField(InstanceConfigProperty.INSTANCE_WEIGHT.name());
        if (w != null) {
            try {
                int weight = Integer.valueOf(w);
                return weight;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setWeight(int weight) {
        if (weight <= 0) {
            throw new IllegalArgumentException("Instance weight can not be equal or less than 0!");
        }
        this._record.setSimpleField(InstanceConfigProperty.INSTANCE_WEIGHT.name(), String.valueOf(weight));
    }

    public List<String> getTags() {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.toString());
        if (tags == null) {
            tags = new ArrayList<String>(0);
        }
        return tags;
    }

    public void addTag(String tag) {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.toString());
        if (tags == null) {
            tags = new ArrayList<String>(0);
        }
        if (!tags.contains(tag)) {
            tags.add(tag);
        }
        this.getRecord().setListField(InstanceConfigProperty.TAG_LIST.toString(), tags);
    }

    public void removeTag(String tag) {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.toString());
        if (tags == null) {
            return;
        }
        if (tags.contains(tag)) {
            tags.remove(tag);
        }
    }

    public boolean containsTag(String tag) {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.toString());
        if (tags == null) {
            return false;
        }
        return tags.contains(tag);
    }

    public boolean getInstanceEnabled() {
        return this._record.getBooleanField(InstanceConfigProperty.HELIX_ENABLED.toString(), true);
    }

    public void setInstanceEnabled(boolean enabled) {
        this._record.setBooleanField(InstanceConfigProperty.HELIX_ENABLED.toString(), enabled);
    }

    @Deprecated
    public boolean getInstanceEnabledForPartition(String partition) {
        boolean enabled = true;
        Map<String, String> disabledPartitionMap = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        for (String resourceName : disabledPartitionMap.keySet()) {
            enabled &= this.getInstanceEnabledForPartition(resourceName, partition);
        }
        return enabled;
    }

    public boolean getInstanceEnabledForPartition(String resource, String partition) {
        List<String> oldDisabledPartition = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        Map<String, String> disabledPartitionsMap = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        return (disabledPartitionsMap == null || !disabledPartitionsMap.containsKey(resource) || !HelixUtil.deserializeByComma(disabledPartitionsMap.get(resource)).contains(partition)) && (oldDisabledPartition == null || !oldDisabledPartition.contains(partition));
    }

    @Deprecated
    public List<String> getDisabledPartitions() {
        List<String> oldDisabled = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        if (!this._record.getMapFields().containsKey(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name()) && oldDisabled == null) {
            return null;
        }
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (oldDisabled != null) {
            disabledPartitions.addAll(oldDisabled);
        }
        for (String perResource : this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name()).values()) {
            disabledPartitions.addAll(HelixUtil.deserializeByComma(perResource));
        }
        return new ArrayList<String>(disabledPartitions);
    }

    public List<String> getDisabledPartitions(String resourceName) {
        List<String> oldDisabled = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        if (!(this._record.getMapFields().containsKey(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name()) && this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name()).containsKey(resourceName) || oldDisabled != null)) {
            return null;
        }
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (oldDisabled != null) {
            disabledPartitions.addAll(oldDisabled);
        }
        disabledPartitions.addAll(HelixUtil.deserializeByComma(this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name()).get(resourceName)));
        return new ArrayList<String>(disabledPartitions);
    }

    public Map<String, List<String>> getDisabledPartitionsMap() {
        Map<String, String> disabledPartitionsRawMap = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        if (disabledPartitionsRawMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> disabledPartitionsMap = new HashMap<String, List<String>>();
        for (String resourceName : disabledPartitionsRawMap.keySet()) {
            disabledPartitionsMap.put(resourceName, this.getDisabledPartitions(resourceName));
        }
        return disabledPartitionsMap;
    }

    @Deprecated
    public void setInstanceEnabledForPartition(String partitionName, boolean enabled) {
        List<String> list = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString());
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (list != null) {
            disabledPartitions.addAll(list);
        }
        if (enabled) {
            disabledPartitions.remove(partitionName);
        } else {
            disabledPartitions.add(partitionName);
        }
        list = new ArrayList<String>(disabledPartitions);
        Collections.sort(list);
        this._record.setListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString(), list);
    }

    public void setInstanceEnabledForPartition(String resourceName, String partitionName, boolean enabled) {
        List<String> oldDisabledPartitions = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        Map<String, String> currentDisabled = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (currentDisabled != null && currentDisabled.containsKey(resourceName)) {
            disabledPartitions.addAll(HelixUtil.deserializeByComma(currentDisabled.get(resourceName)));
        }
        if (enabled) {
            disabledPartitions.remove(partitionName);
            if (oldDisabledPartitions != null && oldDisabledPartitions.contains(partitionName)) {
                oldDisabledPartitions.remove(partitionName);
            }
        } else {
            disabledPartitions.add(partitionName);
        }
        ArrayList<String> disabledPartitionList = new ArrayList<String>(disabledPartitions);
        Collections.sort(disabledPartitionList);
        if (currentDisabled == null) {
            currentDisabled = new HashMap<String, String>();
        }
        if (disabledPartitionList != null) {
            currentDisabled.put(resourceName, HelixUtil.serializeByComma(disabledPartitionList));
        }
        if (!currentDisabled.isEmpty()) {
            this._record.setMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name(), currentDisabled);
        }
        if (oldDisabledPartitions != null && !oldDisabledPartitions.isEmpty()) {
            this._record.setListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name(), oldDisabledPartitions);
        }
    }

    public int getMaxConcurrentTask() {
        return this._record.getIntField(InstanceConfigProperty.MAX_CONCURRENT_TASK.name(), -1);
    }

    public void setMaxConcurrentTask(int maxConcurrentTask) {
        this._record.setIntField(InstanceConfigProperty.MAX_CONCURRENT_TASK.name(), maxConcurrentTask);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InstanceConfig) {
            InstanceConfig that = (InstanceConfig)obj;
            if (this.getId().equals(that.getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getInstanceName() {
        return this._record.getId();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static InstanceConfig toInstanceConfig(String instanceId) {
        char[] delims;
        String host = null;
        int port = -1;
        for (char delim : delims = new char[]{':', '_'}) {
            String regex = String.format("(.*)[%c]([\\d]+)", Character.valueOf(delim));
            if (!instanceId.matches(regex)) continue;
            int lastIndexOf = instanceId.lastIndexOf(delim);
            try {
                port = Integer.parseInt(instanceId.substring(lastIndexOf + 1));
                host = instanceId.substring(0, lastIndexOf);
            }
            catch (Exception e) {
                _logger.warn((Object)("Unable to extract host and port from instanceId:" + instanceId));
            }
            break;
        }
        if (host != null && port > 0) {
            instanceId = host + "_" + port;
        }
        InstanceConfig config = new InstanceConfig(instanceId);
        if (host != null && port > 0) {
            config.setHostName(host);
            config.setPort(String.valueOf(port));
        }
        config.setInstanceEnabled(true);
        if (config.getHostName() == null) {
            config.setHostName(instanceId);
        }
        return config;
    }

    public static enum InstanceConfigProperty {
        HELIX_HOST,
        HELIX_PORT,
        HELIX_ZONE_ID,
        HELIX_ENABLED,
        HELIX_DISABLED_PARTITION,
        TAG_LIST,
        INSTANCE_WEIGHT,
        DOMAIN,
        MAX_CONCURRENT_TASK;

    }
}

