/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.helix.Criteria;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.ZNRecordRow;
import org.apache.log4j.Logger;

public class CriteriaEvaluator {
    private static Logger logger = Logger.getLogger(CriteriaEvaluator.class);

    public List<Map<String, String>> evaluateCriteria(Criteria recipientCriteria, HelixManager manager) {
        List properties;
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        Criteria.DataSource dataSource = recipientCriteria.getDataSource();
        if (dataSource == Criteria.DataSource.EXTERNALVIEW) {
            properties = accessor.getChildValues(keyBuilder.externalViews());
        } else if (dataSource == Criteria.DataSource.IDEALSTATES) {
            properties = accessor.getChildValues(keyBuilder.idealStates());
        } else if (dataSource == Criteria.DataSource.LIVEINSTANCES) {
            properties = accessor.getChildValues(keyBuilder.liveInstances());
        } else if (dataSource == Criteria.DataSource.INSTANCES) {
            properties = accessor.getChildValues(keyBuilder.instances());
        } else {
            return Lists.newArrayList();
        }
        List<ZNRecordRow> allRows = ZNRecordRow.flatten(HelixProperty.convertToList(properties));
        Set<String> liveParticipants = accessor.getChildValuesMap(keyBuilder.liveInstances()).keySet();
        ArrayList result = Lists.newArrayList();
        for (ZNRecordRow row : allRows) {
            if (!this.rowMatches(recipientCriteria, row) || !liveParticipants.contains(row.getRecordId()) && !liveParticipants.contains(row.getMapSubKey())) continue;
            result.add(row);
        }
        HashSet selected = Sets.newHashSet();
        for (ZNRecordRow row : result) {
            HashMap<String, String> resultRow = new HashMap<String, String>();
            resultRow.put("instanceName", !recipientCriteria.getInstanceName().equals("") ? (!Strings.isNullOrEmpty((String)row.getMapSubKey()) ? row.getMapSubKey() : row.getRecordId()) : "");
            resultRow.put("resourceName", !recipientCriteria.getResource().equals("") ? row.getRecordId() : "");
            resultRow.put("partitionName", !recipientCriteria.getPartition().equals("") ? row.getMapKey() : "");
            resultRow.put("partitionState", !recipientCriteria.getPartitionState().equals("") ? row.getMapValue() : "");
            selected.add(resultRow);
        }
        logger.info((Object)("Query returned " + selected.size() + " rows"));
        return Lists.newArrayList((Iterable)selected);
    }

    private boolean rowMatches(Criteria criteria, ZNRecordRow row) {
        String instanceName = this.normalizePattern(criteria.getInstanceName());
        String resourceName = this.normalizePattern(criteria.getResource());
        String partitionName = this.normalizePattern(criteria.getPartition());
        String partitionState = this.normalizePattern(criteria.getPartitionState());
        return (this.stringMatches(instanceName, Strings.nullToEmpty((String)row.getMapSubKey())) || this.stringMatches(instanceName, Strings.nullToEmpty((String)row.getRecordId()))) && this.stringMatches(resourceName, Strings.nullToEmpty((String)row.getRecordId())) && this.stringMatches(partitionName, Strings.nullToEmpty((String)row.getMapKey())) && this.stringMatches(partitionState, Strings.nullToEmpty((String)row.getMapValue()));
    }

    private String normalizePattern(String pattern) {
        if (pattern == null || pattern.equals("") || pattern.equals("*")) {
            pattern = "%";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if ("[](){}.*+?$^|#\\".indexOf(ch) != -1) {
                builder.append("\\");
            }
            builder.append(ch);
        }
        pattern = builder.toString().toLowerCase().replace("_", ".").replace("%", ".*?");
        return pattern;
    }

    private boolean stringMatches(String pattern, String value) {
        Pattern p = Pattern.compile(pattern, 34);
        return p.matcher(value).matches();
    }
}

