/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk.serializer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.serializer.PayloadSerializer;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class JacksonPayloadSerializer
implements PayloadSerializer {
    private static Logger logger = Logger.getLogger(JacksonPayloadSerializer.class);

    @Override
    public <T> byte[] serialize(T data) {
        if (data == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        SerializationConfig serializationConfig = mapper.getSerializationConfig();
        serializationConfig.set(SerializationConfig.Feature.INDENT_OUTPUT, true);
        serializationConfig.set(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        serializationConfig.set(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, data);
        }
        catch (Exception e) {
            logger.error((Object)"Exception during payload data serialization.", (Throwable)e);
            throw new HelixException(e);
        }
        return sw.toString().getBytes();
    }

    @Override
    public <T> T deserialize(Class<T> clazz, byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
        deserializationConfig.set(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        deserializationConfig.set(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, true);
        deserializationConfig.set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        try {
            Object payload = mapper.readValue((InputStream)bais, clazz);
            return (T)payload;
        }
        catch (Exception e) {
            logger.error((Object)("Exception during deserialization of payload bytes: " + new String(bytes)), (Throwable)e);
            return null;
        }
    }
}

