/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.lang.management.ManagementFactory;
import java.util.List;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.manager.zk.ControllerManagerHelper;
import org.apache.helix.model.LeaderHistory;
import org.apache.helix.model.LiveInstance;
import org.apache.log4j.Logger;

public class DistributedLeaderElection
implements ControllerChangeListener {
    private static Logger LOG = Logger.getLogger(DistributedLeaderElection.class);
    final HelixManager _manager;
    final GenericHelixController _controller;
    final List<HelixTimerTask> _controllerTimerTasks;

    public DistributedLeaderElection(HelixManager manager, GenericHelixController controller, List<HelixTimerTask> controllerTimerTasks) {
        this._manager = manager;
        this._controller = controller;
        this._controllerTimerTasks = controllerTimerTasks;
    }

    @Override
    public synchronized void onControllerChange(NotificationContext changeContext) {
        HelixManager manager = changeContext.getManager();
        if (manager == null) {
            LOG.error((Object)"missing attributes in changeContext. requires HelixManager");
            return;
        }
        InstanceType type = manager.getInstanceType();
        if (type != InstanceType.CONTROLLER && type != InstanceType.CONTROLLER_PARTICIPANT) {
            LOG.error((Object)("fail to become controller because incorrect instanceType (was " + type.toString() + ", requires CONTROLLER | CONTROLLER_PARTICIPANT)"));
            return;
        }
        ControllerManagerHelper controllerHelper = new ControllerManagerHelper(this._manager, this._controllerTimerTasks);
        try {
            if (changeContext.getType().equals((Object)NotificationContext.Type.INIT) || changeContext.getType().equals((Object)NotificationContext.Type.CALLBACK)) {
                LOG.info((Object)(this._manager.getInstanceName() + " is trying to acquire leadership for cluster: " + this._manager.getClusterName()));
                HelixDataAccessor accessor = manager.getHelixDataAccessor();
                PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                while (accessor.getProperty(keyBuilder.controllerLeader()) == null) {
                    boolean success = this.tryUpdateController(manager);
                    if (!success) continue;
                    LOG.info((Object)(this._manager.getInstanceName() + " acquired leadership for cluster: " + this._manager.getClusterName()));
                    this.updateHistory(manager);
                    this._manager.getHelixDataAccessor().getBaseDataAccessor().reset();
                    controllerHelper.addListenersToController(this._controller);
                    controllerHelper.startControllerTimerTasks();
                }
            } else if (changeContext.getType().equals((Object)NotificationContext.Type.FINALIZE)) {
                LOG.info((Object)(this._manager.getInstanceName() + " reqlinquish leadership for cluster: " + this._manager.getClusterName()));
                controllerHelper.stopControllerTimerTasks();
                controllerHelper.removeListenersFromController(this._controller);
                this._controller.shutdownClusterStatusMonitor(this._manager.getClusterName());
                this._manager.getHelixDataAccessor().getBaseDataAccessor().reset();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception when trying to become leader", (Throwable)e);
        }
    }

    private boolean tryUpdateController(HelixManager manager) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        LiveInstance leader = new LiveInstance(manager.getInstanceName());
        try {
            leader.setLiveInstance(ManagementFactory.getRuntimeMXBean().getName());
            leader.setSessionId(manager.getSessionId());
            leader.setHelixVersion(manager.getVersion());
            boolean success = accessor.createControllerLeader(leader);
            if (success) {
                return true;
            }
            LOG.info((Object)"Unable to become leader probably because some other controller becames the leader");
        }
        catch (Exception e) {
            LOG.error((Object)("Exception when trying to updating leader record in cluster:" + manager.getClusterName() + ". Need to check again whether leader node has been created or not"), (Throwable)e);
        }
        leader = (LiveInstance)accessor.getProperty(keyBuilder.controllerLeader());
        if (leader != null) {
            String leaderSessionId = leader.getSessionId();
            LOG.info((Object)("Leader exists for cluster: " + manager.getClusterName() + ", currentLeader: " + leader.getInstanceName() + ", leaderSessionId: " + leaderSessionId));
            if (leaderSessionId != null && leaderSessionId.equals(manager.getSessionId())) {
                return true;
            }
        }
        return false;
    }

    private void updateHistory(HelixManager manager) {
        PropertyKey.Builder keyBuilder;
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        LeaderHistory history = (LeaderHistory)accessor.getProperty((keyBuilder = accessor.keyBuilder()).controllerLeaderHistory());
        if (history == null) {
            history = new LeaderHistory(PropertyType.HISTORY.toString());
        }
        history.updateHistory(manager.getClusterName(), manager.getInstanceName());
        accessor.setProperty(keyBuilder.controllerLeaderHistory(), history);
    }
}

