/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Queue;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.log4j.Logger;

public class ClusterEventBlockingQueue {
    private static final Logger LOG = Logger.getLogger(ClusterEventBlockingQueue.class);
    private final Map<String, ClusterEvent> _eventMap = Maps.newHashMap();
    private final Queue<ClusterEvent> _eventQueue = Lists.newLinkedList();

    public synchronized void clear() {
        this._eventMap.clear();
        this._eventQueue.clear();
    }

    public synchronized void put(ClusterEvent event) {
        boolean result;
        if (!this._eventMap.containsKey(event.getName()) && !(result = this._eventQueue.offer(event))) {
            return;
        }
        this._eventMap.put(event.getName(), event);
        LOG.debug((Object)("Putting event " + event.getName()));
        LOG.debug((Object)("Event queue size: " + this._eventQueue.size()));
        this.notify();
    }

    public synchronized ClusterEvent take() throws InterruptedException {
        while (this._eventQueue.isEmpty()) {
            this.wait();
        }
        ClusterEvent queuedEvent = this._eventQueue.poll();
        if (queuedEvent != null) {
            LOG.debug((Object)("Taking event " + queuedEvent.getName()));
            LOG.debug((Object)("Event queue size: " + this._eventQueue.size()));
            return this._eventMap.remove(queuedEvent.getName());
        }
        return null;
    }

    public synchronized ClusterEvent peek() {
        ClusterEvent queuedEvent = this._eventQueue.peek();
        if (queuedEvent != null) {
            return this._eventMap.get(queuedEvent.getName());
        }
        return queuedEvent;
    }

    public int size() {
        return this._eventQueue.size();
    }

    public boolean isEmpty() {
        return this._eventQueue.isEmpty();
    }
}

