/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.rebalancer.AutoRebalancer;
import org.apache.helix.controller.rebalancer.CustomRebalancer;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.SemiAutoRebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobRebalancer;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskRebalancer;
import org.apache.helix.util.HelixUtil;
import org.apache.log4j.Logger;

public class BestPossibleStateCalcStage
extends AbstractBaseStage {
    private static final Logger logger = Logger.getLogger((String)BestPossibleStateCalcStage.class.getName());

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        logger.info((Object)"START BestPossibleStateCalcStage.process()");
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        if (currentStateOutput == null || resourceMap == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires CURRENT_STATE|RESOURCES|DataCache");
        }
        cache.resetActiveTaskCount(currentStateOutput);
        BestPossibleStateOutput bestPossibleStateOutput = this.compute(event, resourceMap, currentStateOutput);
        event.addAttribute(AttributeName.BEST_POSSIBLE_STATE.name(), bestPossibleStateOutput);
        try {
            ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute("clusterStatusMonitor");
            if (clusterStatusMonitor != null) {
                clusterStatusMonitor.setPerInstanceResourceStatus(bestPossibleStateOutput, cache.getInstanceConfigMap(), resourceMap, cache.getStateModelDefMap());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not update cluster status metrics!", (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        logger.info((Object)("END BestPossibleStateCalcStage.process(). took: " + (endTime - startTime) + " ms"));
    }

    private BestPossibleStateOutput compute(ClusterEvent event, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) {
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        BestPossibleStateOutput output = new BestPossibleStateOutput();
        PriorityQueue<ResourcePriority> resourcePriorityQueue = new PriorityQueue<ResourcePriority>();
        TaskDriver taskDriver = null;
        HelixManager helixManager = (HelixManager)event.getAttribute("helixmanager");
        if (helixManager != null) {
            taskDriver = new TaskDriver(helixManager);
        }
        for (Resource resource : resourceMap.values()) {
            resourcePriorityQueue.add(new ResourcePriority(resource, cache.getIdealState(resource.getResourceName()), taskDriver));
        }
        Iterator itr = resourcePriorityQueue.iterator();
        while (itr.hasNext()) {
            this.computeResourceBestPossibleState(event, cache, currentStateOutput, ((ResourcePriority)itr.next()).getResource(), output);
        }
        return output;
    }

    private void computeResourceBestPossibleState(ClusterEvent event, ClusterDataCache cache, CurrentStateOutput currentStateOutput, Resource resource, BestPossibleStateOutput output) {
        String resourceName = resource.getResourceName();
        logger.debug((Object)("Processing resource:" + resourceName));
        IdealState idealState = cache.getIdealState(resourceName);
        if (idealState == null) {
            logger.info((Object)("resource:" + resourceName + " does not exist anymore"));
            idealState = new IdealState(resourceName);
            idealState.setStateModelDefRef(resource.getStateModelDefRef());
        }
        Rebalancer rebalancer = this.getRebalancer(idealState, resourceName);
        MappingCalculator mappingCalculator = this.getMappingCalculator(rebalancer, resourceName);
        if (rebalancer == null || mappingCalculator == null) {
            logger.error((Object)("Error computing assignment for resource " + resourceName + ". no rebalancer found. rebalancer: " + rebalancer + " mappingCaculator: " + mappingCalculator));
        }
        if (rebalancer != null && mappingCalculator != null) {
            if (rebalancer instanceof TaskRebalancer) {
                TaskRebalancer taskRebalancer = (TaskRebalancer)TaskRebalancer.class.cast(rebalancer);
                taskRebalancer.setClusterStatusMonitor((ClusterStatusMonitor)event.getAttribute("clusterStatusMonitor"));
            }
            try {
                HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
                rebalancer.init(manager);
                idealState = rebalancer.computeNewIdealState(resourceName, idealState, currentStateOutput, cache);
                output.setPreferenceLists(resourceName, idealState.getPreferenceLists());
                ResourceAssignment partitionStateAssignment = mappingCalculator.computeBestPossiblePartitionState(cache, idealState, resource, currentStateOutput);
                for (Partition partition : resource.getPartitions()) {
                    Map<String, String> newStateMap = partitionStateAssignment.getReplicaMap(partition);
                    output.setState(resourceName, partition, newStateMap);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error computing assignment for resource " + resourceName + ". Skipping."), (Throwable)e);
            }
        }
    }

    private Rebalancer getRebalancer(IdealState idealState, String resourceName) {
        Rebalancer customizedRebalancer = null;
        String rebalancerClassName = idealState.getRebalancerClassName();
        if (rebalancerClassName != null) {
            logger.info((Object)("resource " + resourceName + " use idealStateRebalancer " + rebalancerClassName));
            try {
                customizedRebalancer = (Rebalancer)Rebalancer.class.cast(HelixUtil.loadClass(this.getClass(), rebalancerClassName).newInstance());
            }
            catch (Exception e) {
                logger.error((Object)("Exception while invoking custom rebalancer class:" + rebalancerClassName), (Throwable)e);
            }
        }
        AbstractRebalancer rebalancer = null;
        switch (idealState.getRebalanceMode()) {
            case FULL_AUTO: {
                if (customizedRebalancer != null) {
                    rebalancer = customizedRebalancer;
                    break;
                }
                rebalancer = new AutoRebalancer();
                break;
            }
            case SEMI_AUTO: {
                rebalancer = new SemiAutoRebalancer();
                break;
            }
            case CUSTOMIZED: {
                rebalancer = new CustomRebalancer();
                break;
            }
            case USER_DEFINED: 
            case TASK: {
                rebalancer = customizedRebalancer;
                break;
            }
            default: {
                logger.error((Object)("Fail to find the rebalancer, invalid rebalance mode " + (Object)((Object)idealState.getRebalanceMode())));
            }
        }
        return rebalancer;
    }

    private MappingCalculator getMappingCalculator(Rebalancer rebalancer, String resourceName) {
        MappingCalculator mappingCalculator = null;
        if (rebalancer != null) {
            try {
                mappingCalculator = (MappingCalculator)MappingCalculator.class.cast(rebalancer);
            }
            catch (ClassCastException e) {
                logger.warn((Object)("Rebalancer does not have a mapping calculator, defaulting to SEMI_AUTO, resource: " + resourceName));
            }
        }
        if (mappingCalculator == null) {
            mappingCalculator = new SemiAutoRebalancer();
        }
        return mappingCalculator;
    }

    class ResourcePriority
    implements Comparable<ResourcePriority> {
        final Resource _resource;
        Long _priority = Long.MAX_VALUE;

        Resource getResource() {
            return this._resource;
        }

        public ResourcePriority(Resource resource, IdealState idealState, TaskDriver taskDriver) {
            JobContext jobContext;
            this._resource = resource;
            if (taskDriver != null && idealState != null && idealState.getRebalancerClassName() != null && idealState.getRebalancerClassName().equals(JobRebalancer.class.getName()) && (jobContext = taskDriver.getJobContext(resource.getResourceName())) != null && jobContext.getStartTime() != -1L) {
                this._priority = jobContext.getStartTime();
            }
        }

        @Override
        public int compareTo(ResourcePriority otherJob) {
            return this._priority.compareTo(otherJob._priority);
        }
    }
}

