/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.topology;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.controller.rebalancer.topology.Node;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.log4j.Logger;

public class Topology {
    private static Logger logger = Logger.getLogger(Topology.class);
    private static final int DEFAULT_NODE_WEIGHT = 1000;
    private final MessageDigest _md;
    private Node _root;
    private List<String> _allInstances;
    private List<String> _liveInstances;
    private Map<String, InstanceConfig> _instanceConfigMap;
    private HelixProperty _clusterConfig;
    private String _faultZoneType;
    private String _endNodeType;
    private boolean _useDefaultTopologyDef;
    private LinkedHashSet<String> _types;
    private Map<String, String> _defaultDomainPathValues = new HashMap<String, String>();

    public Topology(List<String> allNodes, List<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, ClusterConfig clusterConfig) {
        try {
            this._md = MessageDigest.getInstance("SHA-1");
            this._allInstances = allNodes;
            this._liveInstances = liveNodes;
            this._instanceConfigMap = instanceConfigMap;
            this._clusterConfig = clusterConfig;
            this._types = new LinkedHashSet();
            String topologyDef = this._clusterConfig.getRecord().getSimpleField(ClusterConfig.ClusterConfigProperty.TOPOLOGY.name());
            if (topologyDef != null) {
                String[] types = topologyDef.trim().split("/");
                for (int i = 0; i < types.length; ++i) {
                    if (types[i].length() == 0) continue;
                    this._types.add(types[i]);
                }
                if (this._types.size() == 0) {
                    logger.error((Object)("Invalid cluster topology definition " + topologyDef));
                    throw new HelixException("Invalid cluster topology definition " + topologyDef);
                }
                String lastType = null;
                for (String type : this._types) {
                    this._defaultDomainPathValues.put(type, "Helix_default_" + type);
                    lastType = type;
                }
                this._endNodeType = lastType;
                this._faultZoneType = this._clusterConfig.getRecord().getStringField(ClusterConfig.ClusterConfigProperty.FAULT_ZONE_TYPE.name(), this._endNodeType);
                if (!this._types.contains(this._faultZoneType)) {
                    throw new HelixException(String.format("Invalid fault zone type %s, not present in topology definition %s.", this._faultZoneType, topologyDef));
                }
                this._useDefaultTopologyDef = false;
            } else {
                this._types.add(Types.ZONE.name());
                this._types.add(Types.INSTANCE.name());
                this._endNodeType = Types.INSTANCE.name();
                this._faultZoneType = Types.ZONE.name();
                this._useDefaultTopologyDef = true;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
        this._root = this._useDefaultTopologyDef ? this.createClusterTreeWithDefaultTopologyDef() : this.createClusterTreeWithCustomizedTopology();
    }

    public String getEndNodeType() {
        return this._endNodeType;
    }

    public String getFaultZoneType() {
        return this._faultZoneType;
    }

    public Node getRootNode() {
        return this._root;
    }

    public List<Node> getFaultZones() {
        if (this._root != null) {
            return this._root.findChildren(this.getFaultZoneType());
        }
        return Collections.emptyList();
    }

    public static List<Node> getAllLeafNodes(Node root) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (root.isLeaf()) {
            nodes.add(root);
        } else {
            for (Node child : root.getChildren()) {
                nodes.addAll(Topology.getAllLeafNodes(child));
            }
        }
        return nodes;
    }

    public static Node clone(Node root, Map<String, Integer> newNodeWeight, Set<String> failedNodes) {
        Node newRoot = Topology.cloneTree(root, newNodeWeight, failedNodes);
        Topology.computeWeight(newRoot);
        return newRoot;
    }

    private static Node cloneTree(Node root, Map<String, Integer> newNodeWeight, Set<String> failedNodes) {
        List<Node> children;
        Node newRoot = new Node(root);
        if (newNodeWeight.containsKey(root.getName())) {
            newRoot.setWeight(newNodeWeight.get(root.getName()).intValue());
        }
        if (failedNodes.contains(root.getName())) {
            newRoot.setFailed(true);
            newRoot.setWeight(0L);
        }
        if ((children = root.getChildren()) != null) {
            for (int i = 0; i < children.size(); ++i) {
                Node newChild = Topology.cloneTree(children.get(i), newNodeWeight, failedNodes);
                newChild.setParent(root);
                newRoot.addChild(newChild);
            }
        }
        return newRoot;
    }

    private Node createClusterTreeWithDefaultTopologyDef() {
        Node root = new Node();
        root.setName("root");
        root.setId(this.computeId("root"));
        root.setType(Types.ROOT.name());
        for (String ins : this._allInstances) {
            InstanceConfig config = this._instanceConfigMap.get(ins);
            if (config == null) {
                throw new HelixException(String.format("Config for instance %s is not found!", ins));
            }
            String zone = config.getZoneId();
            if (zone == null) {
                throw new HelixException(String.format("ZONE_ID for instance %s is not set, failed the topology-aware placement!", ins));
            }
            HashMap<String, String> pathValueMap = new HashMap<String, String>();
            pathValueMap.put(Types.ZONE.name(), zone);
            pathValueMap.put(Types.INSTANCE.name(), ins);
            int weight = config.getWeight();
            if (weight < 0 || weight == -1) {
                weight = 1000;
            }
            root = this.addEndNode(root, ins, pathValueMap, weight, this._liveInstances);
        }
        return root;
    }

    private Node createClusterTreeWithCustomizedTopology() {
        Node root = new Node();
        root.setName("root");
        root.setId(this.computeId("root"));
        root.setType(Types.ROOT.name());
        for (String ins : this._allInstances) {
            InstanceConfig insConfig = this._instanceConfigMap.get(ins);
            if (insConfig == null) {
                throw new HelixException(String.format("Config for instance %s is not found!", ins));
            }
            String domain = insConfig.getDomain();
            if (domain == null) {
                throw new HelixException(String.format("Domain for instance %s is not set, failed the topology-aware placement!", ins));
            }
            String[] pathPairs = domain.trim().split(",");
            HashMap<String, String> pathValueMap = new HashMap<String, String>();
            for (String pair : pathPairs) {
                String[] values = pair.trim().split("=");
                if (values.length != 2 || values[0].isEmpty() || values[1].isEmpty()) {
                    throw new HelixException(String.format("Domain-Value pair %s for instance %s is not valid, failed the topology-aware placement!", pair, ins));
                }
                String type = values[0];
                String value = values[1];
                if (!this._types.contains(type)) {
                    logger.warn((Object)String.format("Path %s defined in domain of instance %s not recognized, ignored!", pair, ins));
                    continue;
                }
                pathValueMap.put(type, value);
            }
            int weight = insConfig.getWeight();
            if (weight < 0 || weight == -1) {
                weight = 1000;
            }
            root = this.addEndNode(root, ins, pathValueMap, weight, this._liveInstances);
        }
        return root;
    }

    private Node addEndNode(Node root, String instanceName, Map<String, String> pathNameMap, int instanceWeight, List<String> liveInstances) {
        Node current = root;
        ArrayList<Node> pathNodes = new ArrayList<Node>();
        for (String path : this._types) {
            String pathValue = pathNameMap.get(path);
            if (pathValue == null || pathValue.isEmpty()) {
                pathValue = this._defaultDomainPathValues.get(path);
            }
            pathNodes.add(current);
            if (!current.hasChild(pathValue)) {
                Node n = new Node();
                n.setName(pathValue);
                n.setId(this.computeId(pathValue));
                n.setType(path);
                n.setParent(current);
                if (path.equals(this._endNodeType)) {
                    if (liveInstances.contains(instanceName)) {
                        n.setWeight(instanceWeight);
                        for (Node node : pathNodes) {
                            node.addWeight(instanceWeight);
                        }
                    } else {
                        n.setFailed(true);
                        n.setWeight(0L);
                    }
                }
                current.addChild(n);
            }
            current = current.getChild(pathValue);
        }
        return root;
    }

    private long computeId(String name) {
        byte[] h = this._md.digest(name.getBytes());
        return this.bstrTo32bit(h);
    }

    private static void computeWeight(Node node) {
        int weight = 0;
        for (Node child : node.getChildren()) {
            if (child.isFailed()) continue;
            weight = (int)((long)weight + child.getWeight());
        }
        node.setWeight(weight);
    }

    private long bstrTo32bit(byte[] bstr) {
        if (bstr.length < 4) {
            throw new IllegalArgumentException("hashed is less than 4 bytes!");
        }
        return (long)(this.ord(bstr[0]) << 24 | this.ord(bstr[1]) << 16 | this.ord(bstr[2]) << 8 | this.ord(bstr[3])) & 0xFFFFFFFFL;
    }

    private int ord(byte b) {
        return b & 0xFF;
    }

    public static enum Types {
        ROOT,
        ZONE,
        INSTANCE;

    }
}

