/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.common;

import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.message.stream.StreamException;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import java.net.URI;
import java.util.Map;

public class HttpBridge {
    public static TransportCallback<RestResponse> restToHttpCallback(final TransportCallback<RestResponse> callback, RestRequest request) {
        final URI uri = request.getURI();
        return new TransportCallback<RestResponse>(){

            @Override
            public void onResponse(TransportResponse<RestResponse> response) {
                if (response.hasError()) {
                    response = TransportResponseImpl.error(new RemoteInvocationException("Failed to get response from server for URI " + uri, response.getError()), response.getWireAttributes());
                } else if (!RestStatus.isOK(response.getResponse().getStatus())) {
                    response = TransportResponseImpl.error(new RestException(response.getResponse(), "Received error " + response.getResponse().getStatus() + " from server for URI " + uri), response.getWireAttributes());
                }
                callback.onResponse(response);
            }
        };
    }

    public static RestRequest toRestRequest(RestRequest request, Map<String, String> headers) {
        return ((RestRequestBuilder)new RestRequestBuilder(request).unsafeSetHeaders(headers)).build();
    }

    public static TransportCallback<RestResponse> httpToRestCallback(final TransportCallback<RestResponse> callback) {
        return new TransportCallback<RestResponse>(){

            @Override
            public void onResponse(TransportResponse<RestResponse> response) {
                Throwable ex;
                if (response.hasError() && (ex = response.getError()) instanceof RestException) {
                    callback.onResponse(TransportResponseImpl.success(((RestException)ex).getResponse(), response.getWireAttributes()));
                    return;
                }
                callback.onResponse(response);
            }
        };
    }

    public static TransportCallback<StreamResponse> streamToHttpCallback(final TransportCallback<StreamResponse> callback, StreamRequest request) {
        final URI uri = request.getURI();
        return new TransportCallback<StreamResponse>(){

            @Override
            public void onResponse(TransportResponse<StreamResponse> response) {
                if (response.hasError()) {
                    response = TransportResponseImpl.error(new RemoteInvocationException("Failed to get response from server for URI " + uri, response.getError()), response.getWireAttributes());
                } else if (!RestStatus.isOK(response.getResponse().getStatus())) {
                    response = TransportResponseImpl.error(new StreamException(response.getResponse(), "Received error " + response.getResponse().getStatus() + " from server for URI " + uri), response.getWireAttributes());
                }
                callback.onResponse(response);
            }
        };
    }

    public static StreamRequest toStreamRequest(StreamRequest request, Map<String, String> headers) {
        return ((StreamRequestBuilder)request.builder().unsafeSetHeaders(headers)).build(request.getEntityStream());
    }

    public static TransportCallback<StreamResponse> httpToStreamCallback(final TransportCallback<StreamResponse> callback) {
        return new TransportCallback<StreamResponse>(){

            @Override
            public void onResponse(TransportResponse<StreamResponse> response) {
                Throwable ex;
                if (response.hasError() && (ex = response.getError()) instanceof StreamException) {
                    callback.onResponse(TransportResponseImpl.success(((StreamException)ex).getResponse(), response.getWireAttributes()));
                    return;
                }
                callback.onResponse(response);
            }
        };
    }
}

