/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.util.Timeout;
import com.linkedin.r2.util.TimeoutExecutor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeoutCallback<T>
implements Callback<T>,
TimeoutExecutor {
    private final Timeout<Callback<T>> _timeout;

    public TimeoutCallback(ScheduledExecutorService executor, long timeout, TimeUnit timeoutUnit, final Callback<T> callback, final String timeoutMessage) {
        this._timeout = new Timeout<Callback<Callback<T>>>(executor, timeout, timeoutUnit, callback);
        this._timeout.addTimeoutTask(new Runnable(){

            @Override
            public void run() {
                callback.onError((Throwable)new TimeoutException(timeoutMessage));
            }
        });
    }

    public void onSuccess(T t) {
        Callback<T> callback = this._timeout.getItem();
        if (callback != null) {
            callback.onSuccess(t);
        }
    }

    public void onError(Throwable e) {
        Callback<T> callback = this._timeout.getItem();
        if (callback != null) {
            callback.onError(e);
        }
    }

    @Override
    public void addTimeoutTask(Runnable action) {
        this._timeout.addTimeoutTask(action);
    }
}

