/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.transport;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.transport.ClientRequestFilter;
import com.linkedin.r2.filter.transport.ResponseFilter;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import java.util.Map;

public class FilterChainClient
implements TransportClient {
    private final TransportClient _client;
    private final FilterChain _filters;

    public FilterChainClient(TransportClient client, FilterChain filters) {
        this._client = client;
        ResponseFilter responseFilter = new ResponseFilter();
        ClientRequestFilter requestFilter = new ClientRequestFilter(this._client);
        this._filters = filters.addFirstRest(responseFilter).addLastRest(requestFilter).addFirst(responseFilter).addLast(requestFilter);
    }

    @Override
    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        ResponseFilter.registerCallback(callback, requestContext);
        this._filters.onRestRequest(request, requestContext, wireAttrs);
    }

    @Override
    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        ResponseFilter.registerCallback(callback, requestContext);
        this._filters.onStreamRequest(request, requestContext, wireAttrs);
    }

    @Override
    public void shutdown(Callback<None> callback) {
        this._client.shutdown(callback);
    }
}

