/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter;

import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.FilterChainImpl;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import java.util.List;

public class FilterChains {
    private static final FilterChain EMPTY_FILTER_CHAIN = new FilterChainImpl();

    public static FilterChain empty() {
        return EMPTY_FILTER_CHAIN;
    }

    public static FilterChain createRestChain(RestFilter ... filters) {
        FilterChain fc = FilterChains.empty();
        for (RestFilter filter : filters) {
            fc = fc.addLastRest(filter);
        }
        return fc;
    }

    public static FilterChain createStreamChain(StreamFilter ... filters) {
        FilterChain fc = FilterChains.empty();
        for (StreamFilter filter : filters) {
            fc = fc.addLast(filter);
        }
        return fc;
    }

    public static FilterChain create(List<RestFilter> restFilters, List<StreamFilter> streamFilters) {
        FilterChain fc = FilterChains.empty();
        if (restFilters != null) {
            for (RestFilter restFilter : restFilters) {
                fc = fc.addLastRest(restFilter);
            }
        }
        if (streamFilters != null) {
            for (StreamFilter streamFilter : streamFilters) {
                fc = fc.addLast(streamFilter);
            }
        }
        return fc;
    }
}

