/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import com.linkedin.restli.docgen.TemplatingEngine;
import com.linkedin.restli.internal.server.RestLiInternalException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.runtime.resource.loader.JarResourceLoader;

public class VelocityTemplatingEngine
implements TemplatingEngine {
    private static final String VELOCITY_TEMPLATE_DIR = "vmTemplates";
    private final VelocityEngine _velocity;

    public VelocityTemplatingEngine() {
        URL templateDirUrl = this.getClass().getClassLoader().getResource(VELOCITY_TEMPLATE_DIR);
        if (templateDirUrl == null) {
            throw new RestLiInternalException("Unable to find the Velocity template resources");
        }
        if ("jar".equals(templateDirUrl.getProtocol())) {
            this._velocity = new VelocityEngine();
            this._velocity.setProperty("resource.loader", (Object)"jar");
            StringBuilder configName = new StringBuilder("jar.").append("resource.loader").append(".class");
            this._velocity.setProperty(configName.toString(), (Object)JarResourceLoader.class.getName());
            configName = new StringBuilder("jar.").append("resource.loader").append(".path");
            String normalizedUrl = templateDirUrl.toString().substring(0, templateDirUrl.toString().length() - VELOCITY_TEMPLATE_DIR.length());
            this._velocity.setProperty(configName.toString(), (Object)normalizedUrl);
        } else if ("file".equals(templateDirUrl.getProtocol())) {
            this._velocity = new VelocityEngine();
            String resourceDirPath = new File(templateDirUrl.getPath()).getParent();
            StringBuilder configName = new StringBuilder("file.").append("resource.loader").append(".path");
            this._velocity.setProperty(configName.toString(), (Object)resourceDirPath);
        } else {
            throw new IllegalArgumentException("Unsupported template path scheme");
        }
        this._velocity.setProperty("runtime.log.logsystem.class", (Object)Log4JLogChute.class.getName());
        this._velocity.setProperty("runtime.log.logsystem.log4j.logger", (Object)this.getClass().getName());
        try {
            this._velocity.init();
        }
        catch (Exception e) {
            throw new RestLiInternalException((Throwable)e);
        }
    }

    @Override
    public void render(String templateName, Map<String, Object> pageModel, OutputStream out) {
        if (this._velocity == null) {
            return;
        }
        String actualTemplateName = "vmTemplates/" + templateName;
        VelocityContext context = new VelocityContext(pageModel);
        OutputStreamWriter outWriter = new OutputStreamWriter(out);
        try {
            this._velocity.mergeTemplate(actualTemplateName, "ISO-8859-1", (Context)context, (Writer)outWriter);
        }
        catch (Exception e) {
            throw new RestLiInternalException((Throwable)e);
        }
        try {
            ((Writer)outWriter).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

