/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.docgen.BaseResourceSchemaVisitor;
import com.linkedin.restli.docgen.ResourceSchemaVisitior;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.model.ResourceModelEncoder;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionSchemaArray;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.EntitySchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.FinderSchemaArray;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.RestMethodSchemaArray;
import com.linkedin.restli.restspec.RestSpecCodec;
import com.linkedin.restli.restspec.SimpleSchema;
import com.linkedin.restli.server.ResourceLevel;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ResourceSchemaCollection {
    private final Map<String, ResourceSchema> _allResources;
    private final Map<ResourceSchema, List<ResourceSchema>> _subResources;
    private final Map<ResourceSchema, List<ResourceSchema>> _parentResources;

    public static ResourceSchemaCollection loadOrCreateResourceSchema(Map<String, ResourceModel> rootResources) {
        ResourceModelEncoder encoder = new ResourceModelEncoder((ResourceModelEncoder.DocsProvider)new ResourceModelEncoder.NullDocsProvider());
        TreeMap<String, ResourceSchema> schemaMap = new TreeMap<String, ResourceSchema>();
        for (ResourceModel resource : rootResources.values()) {
            schemaMap.put(resource.getName(), encoder.loadOrBuildResourceSchema(resource));
        }
        return new ResourceSchemaCollection(schemaMap);
    }

    public static ResourceSchemaCollection createFromIdls(String[] restspecSearchPaths) {
        RestSpecCodec codec = new RestSpecCodec();
        HashMap<String, ResourceSchema> resourceSchemaMap = new HashMap<String, ResourceSchema>();
        for (String path : restspecSearchPaths) {
            File[] idlFiles;
            File dir = new File(path);
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(String.format("path '%s' is not a directory", dir.getAbsolutePath()));
            }
            for (File idlFile : idlFiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".restspec.json");
                }
            })) {
                try {
                    FileInputStream is = new FileInputStream(idlFile);
                    ResourceSchema resourceSchema = codec.readResourceSchema((InputStream)is);
                    resourceSchemaMap.put(resourceSchema.getName(), resourceSchema);
                }
                catch (IOException e) {
                    throw new RestLiInternalException(String.format("Error loading restspec IDL file '%s'", idlFile.getName()), (Throwable)e);
                }
            }
        }
        return new ResourceSchemaCollection(resourceSchemaMap);
    }

    public static void visitResources(Collection<ResourceSchema> resources, ResourceSchemaVisitior visitor) {
        for (ResourceSchema schema : resources) {
            ResourceSchemaCollection.processResourceSchema(visitor, new ArrayList<ResourceSchema>(), schema);
        }
    }

    public ResourceSchemaCollection(Map<String, ResourceSchema> rootResources) {
        this._allResources = new TreeMap<String, ResourceSchema>(rootResources);
        this._subResources = new IdentityHashMap<ResourceSchema, List<ResourceSchema>>();
        this._parentResources = new IdentityHashMap<ResourceSchema, List<ResourceSchema>>();
        final TreeMap flattenSubResources = new TreeMap();
        BaseResourceSchemaVisitor visitor = new BaseResourceSchemaVisitor(){

            @Override
            public void visitResourceSchema(ResourceSchemaVisitior.VisitContext context, ResourceSchema resourceSchema) {
                String qualifiedResourceName = context.getResourcePath();
                if (!ResourceSchemaCollection.this._allResources.containsKey(qualifiedResourceName)) {
                    flattenSubResources.put(qualifiedResourceName, resourceSchema);
                    List<ResourceSchema> hierarchy = context.getResourceSchemaHierarchy();
                    ArrayList<ResourceSchema> parents = new ArrayList<ResourceSchema>(hierarchy);
                    parents.remove(parents.size() - 1);
                    ResourceSchemaCollection.this._parentResources.put(resourceSchema, parents);
                    ResourceSchema directParent = parents.get(parents.size() - 1);
                    ArrayList<ResourceSchema> subList = (ArrayList<ResourceSchema>)ResourceSchemaCollection.this._subResources.get(directParent);
                    if (subList == null) {
                        subList = new ArrayList<ResourceSchema>();
                        ResourceSchemaCollection.this._subResources.put(directParent, subList);
                    }
                    subList.add(resourceSchema);
                }
            }
        };
        ResourceSchemaCollection.visitResources(this._allResources.values(), visitor);
        this._allResources.putAll(flattenSubResources);
    }

    public ResourceSchema getResource(String resourcePath) {
        return this._allResources.get(resourcePath);
    }

    public Map<String, ResourceSchema> getResources() {
        return this._allResources;
    }

    public List<ResourceSchema> getSubResources(ResourceSchema parentSchema) {
        return this._subResources.get(parentSchema);
    }

    public List<ResourceSchema> getParentResources(ResourceSchema parentSchema) {
        List<ResourceSchema> parents = this._parentResources.get(parentSchema);
        if (parents == null) {
            return Collections.emptyList();
        }
        return parents;
    }

    public List<ResourceSchema> getAllSubResources(ResourceSchema ancestorSchema) {
        return this.getAllSubResourcesRecursive(ancestorSchema, new ArrayList<ResourceSchema>());
    }

    private List<ResourceSchema> getAllSubResourcesRecursive(ResourceSchema parentSchema, List<ResourceSchema> accumulator) {
        List<ResourceSchema> subResources = this.getSubResources(parentSchema);
        if (subResources == null) {
            return null;
        }
        accumulator.addAll(subResources);
        for (ResourceSchema sub : subResources) {
            this.getAllSubResourcesRecursive(sub, accumulator);
        }
        return accumulator;
    }

    private static void processResourceSchema(ResourceSchemaVisitior visitor, List<ResourceSchema> hierarchy, ResourceSchema resourceSchema) {
        hierarchy.add(resourceSchema);
        ResourceSchemaVisitior.VisitContext context = ResourceSchemaCollection.buildContext(hierarchy);
        visitor.visitResourceSchema(context, resourceSchema);
        if (resourceSchema.hasCollection()) {
            CollectionSchema collectionSchema = resourceSchema.getCollection();
            visitor.visitCollectionResource(context, collectionSchema);
            ResourceSchemaCollection.processRestMethods(visitor, context, (RecordTemplate)collectionSchema, collectionSchema.getMethods());
            ResourceSchemaCollection.processFinders(visitor, context, (RecordTemplate)collectionSchema, collectionSchema.getFinders());
            ResourceSchemaCollection.processActions(visitor, context, (RecordTemplate)collectionSchema, collectionSchema.getActions());
            ResourceSchemaCollection.processEntitySchema(visitor, context, collectionSchema.getEntity());
        } else if (resourceSchema.hasAssociation()) {
            AssociationSchema associationSchema = resourceSchema.getAssociation();
            visitor.visitAssociationResource(context, associationSchema);
            ResourceSchemaCollection.processRestMethods(visitor, context, (RecordTemplate)associationSchema, associationSchema.getMethods());
            ResourceSchemaCollection.processFinders(visitor, context, (RecordTemplate)associationSchema, associationSchema.getFinders());
            ResourceSchemaCollection.processActions(visitor, context, (RecordTemplate)associationSchema, associationSchema.getActions());
            ResourceSchemaCollection.processEntitySchema(visitor, context, associationSchema.getEntity());
        } else if (resourceSchema.hasSimple()) {
            SimpleSchema simpleSchema = resourceSchema.getSimple();
            visitor.visitSimpleResource(context, simpleSchema);
            ResourceSchemaCollection.processRestMethods(visitor, context, (RecordTemplate)simpleSchema, simpleSchema.getMethods());
            ResourceSchemaCollection.processActions(visitor, context, (RecordTemplate)simpleSchema, simpleSchema.getActions());
            ResourceSchemaCollection.processEntitySchema(visitor, context, simpleSchema.getEntity());
        } else if (resourceSchema.hasActionsSet()) {
            ActionsSetSchema actionsSet = resourceSchema.getActionsSet();
            visitor.visitActionSetResource(context, actionsSet);
            ResourceSchemaCollection.processActions(visitor, context, (RecordTemplate)actionsSet, actionsSet.getActions());
        }
        hierarchy.remove(hierarchy.size() - 1);
    }

    private static void processEntitySchema(ResourceSchemaVisitior visitor, ResourceSchemaVisitior.VisitContext context, EntitySchema entitySchema) {
        visitor.visitEntityResource(context, entitySchema);
        ResourceSchemaCollection.processActions(visitor, context, (RecordTemplate)entitySchema, entitySchema.getActions());
        if (entitySchema.hasSubresources()) {
            for (ResourceSchema resourceSchema : entitySchema.getSubresources()) {
                ResourceSchemaCollection.processResourceSchema(visitor, context.getResourceSchemaHierarchy(), resourceSchema);
            }
        }
    }

    private static void processRestMethods(ResourceSchemaVisitior visitor, ResourceSchemaVisitior.VisitContext context, RecordTemplate containingResourceType, RestMethodSchemaArray methods) {
        if (methods != null) {
            for (RestMethodSchema restMethodSchema : methods) {
                visitor.visitRestMethod(context, containingResourceType, restMethodSchema);
                if (!restMethodSchema.hasParameters()) continue;
                for (ParameterSchema parameterSchema : restMethodSchema.getParameters()) {
                    visitor.visitParameter(context, containingResourceType, restMethodSchema, parameterSchema);
                }
            }
        }
    }

    private static void processFinders(ResourceSchemaVisitior visitor, ResourceSchemaVisitior.VisitContext context, RecordTemplate containingResourceType, FinderSchemaArray finders) {
        if (finders != null) {
            for (FinderSchema finderSchema : finders) {
                visitor.visitFinder(context, containingResourceType, finderSchema);
                if (!finderSchema.hasParameters()) continue;
                for (ParameterSchema parameterSchema : finderSchema.getParameters()) {
                    visitor.visitParameter(context, containingResourceType, finderSchema, parameterSchema);
                }
            }
        }
    }

    private static void processActions(ResourceSchemaVisitior visitor, ResourceSchemaVisitior.VisitContext context, RecordTemplate containingResourceType, ActionSchemaArray actions) {
        if (actions != null) {
            ResourceLevel resourceLevel = EntitySchema.class.equals(containingResourceType.getClass()) || SimpleSchema.class.equals(containingResourceType.getClass()) ? ResourceLevel.ENTITY : ResourceLevel.COLLECTION;
            for (ActionSchema actionSchema : actions) {
                visitor.visitAction(context, containingResourceType, resourceLevel, actionSchema);
                if (!actionSchema.hasParameters()) continue;
                for (ParameterSchema parameterSchema : actionSchema.getParameters()) {
                    visitor.visitParameter(context, containingResourceType, actionSchema, parameterSchema);
                }
            }
        }
    }

    private static ResourceSchemaVisitior.VisitContext buildContext(List<ResourceSchema> hierarchy) {
        StringBuilder resourcePath = new StringBuilder();
        for (ResourceSchema resourceSchema : hierarchy) {
            resourcePath.append(resourceSchema.getName()).append(".");
        }
        resourcePath.deleteCharAt(resourcePath.length() - 1);
        return new ResourceSchemaVisitior.VisitContext(hierarchy, resourcePath.toString());
    }
}

