/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.google.common.base.Optional;
import com.google.common.io.Closer;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.Future;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.runtime.spec_executorInstance.AbstractSpecExecutor;
import org.apache.gobblin.service.SimpleKafkaSpecProducer;
import org.apache.gobblin.util.CompletedFuture;
import org.slf4j.Logger;

public class SimpleKafkaSpecExecutor
extends AbstractSpecExecutor {
    public static final String SPEC_KAFKA_TOPICS_KEY = "spec.kafka.topics";
    protected static final String VERB_KEY = "Verb";
    private SpecProducer<Spec> specProducer;

    public SimpleKafkaSpecExecutor(Config config, Optional<Logger> log) {
        super(config, log);
        this.specProducer = new SimpleKafkaSpecProducer(config, log);
    }

    public SimpleKafkaSpecExecutor(Config config) {
        this(config, (Optional<Logger>)Optional.absent());
    }

    public Future<? extends SpecProducer> getProducer() {
        return new CompletedFuture(this.specProducer, null);
    }

    public Future<String> getDescription() {
        return new CompletedFuture((Object)("SimpleSpecExecutorInstance with URI: " + this.specExecutorInstanceUri), null);
    }

    protected void startUp() throws Exception {
        this.optionalCloser = Optional.of((Object)Closer.create());
        this.specProducer = (SpecProducer)((Closer)this.optionalCloser.get()).register((Closeable)((SimpleKafkaSpecProducer)this.specProducer));
    }

    protected void shutDown() throws Exception {
        if (this.optionalCloser.isPresent()) {
            ((Closer)this.optionalCloser.get()).close();
        } else {
            this.log.warn("There's no Closer existed in " + ((Object)((Object)this)).getClass().getName());
        }
    }

    public static class SpecExecutorInstanceDataPacket
    implements Serializable {
        protected SpecExecutor.Verb _verb;
        protected URI _uri;
        protected Spec _spec;

        public SpecExecutorInstanceDataPacket(SpecExecutor.Verb verb, URI uri, Spec spec) {
            this._verb = verb;
            this._uri = uri;
            this._spec = spec;
        }

        public String toString() {
            return String.format("Verb: %s, URI: %s, Spec: %s", this._verb, this._uri, this._spec);
        }
    }
}

