/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.kafka.client.ByteArrayBasedKafkaRecord;
import org.apache.gobblin.kafka.client.DecodeableKafkaRecord;
import org.apache.gobblin.kafka.client.GobblinKafkaConsumerClient;
import org.apache.gobblin.kafka.client.KafkaConsumerRecord;
import org.apache.gobblin.metrics.reporter.util.FixedSchemaVersionWriter;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecConsumer;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.job_spec.AvroJobSpec;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaOffsetRetrievalFailureException;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaTopic;
import org.apache.gobblin.util.CompletedFuture;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleKafkaSpecConsumer
implements SpecConsumer<Spec>,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(SimpleKafkaSpecConsumer.class);
    private static final String CONSUMER_CLIENT_FACTORY_CLASS_KEY = "spec.kafka.consumerClientClassFactory";
    private static final String DEFAULT_CONSUMER_CLIENT_FACTORY_CLASS = "org.apache.gobblin.kafka.client.Kafka08ConsumerClient$Factory";
    protected final GobblinKafkaConsumerClient _kafkaConsumer;
    protected final List<KafkaPartition> _partitions;
    protected final List<Long> _lowWatermark;
    protected final List<Long> _nextWatermark;
    protected final List<Long> _highWatermark;
    private Iterator<KafkaConsumerRecord> messageIterator = null;
    private int currentPartitionIdx = -1;
    private boolean isFirstRun = true;
    private final BinaryDecoder _decoder;
    private final SpecificDatumReader<AvroJobSpec> _reader;
    private final SchemaVersionWriter<?> _versionWriter;

    public SimpleKafkaSpecConsumer(Config config, Optional<Logger> log) {
        String kafkaConsumerClientClass = ConfigUtils.getString((Config)config, (String)CONSUMER_CLIENT_FACTORY_CLASS_KEY, (String)DEFAULT_CONSUMER_CLIENT_FACTORY_CLASS);
        try {
            Class<?> clientFactoryClass = Class.forName(kafkaConsumerClientClass);
            GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory factory = (GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory)ConstructorUtils.invokeConstructor(clientFactoryClass, (Object[])new Object[0]);
            this._kafkaConsumer = factory.create(config);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (log.isPresent()) {
                ((Logger)log.get()).error("Failed to instantiate Kafka consumer from class " + kafkaConsumerClientClass, (Throwable)e);
            }
            throw new RuntimeException("Failed to instantiate Kafka consumer", e);
        }
        List kafkaTopics = this._kafkaConsumer.getFilteredTopics(Collections.EMPTY_LIST, (List)Lists.newArrayList((Object[])new Pattern[]{Pattern.compile(config.getString("spec.kafka.topics"))}));
        this._partitions = ((KafkaTopic)kafkaTopics.get(0)).getPartitions();
        this._lowWatermark = Lists.newArrayList(Collections.nCopies(this._partitions.size(), 0L));
        this._nextWatermark = Lists.newArrayList(Collections.nCopies(this._partitions.size(), 0L));
        this._highWatermark = Lists.newArrayList(Collections.nCopies(this._partitions.size(), 0L));
        ByteArrayInputStream dummyInputStream = new ByteArrayInputStream(new byte[0]);
        this._decoder = DecoderFactory.get().binaryDecoder((InputStream)dummyInputStream, null);
        this._reader = new SpecificDatumReader(AvroJobSpec.SCHEMA$);
        this._versionWriter = new FixedSchemaVersionWriter();
    }

    public SimpleKafkaSpecConsumer(Config config, Logger log) {
        this(config, (Optional<Logger>)Optional.of((Object)log));
    }

    public SimpleKafkaSpecConsumer(Config config) {
        this(config, (Optional<Logger>)Optional.absent());
    }

    public Future<? extends List<Pair<SpecExecutor.Verb, Spec>>> changedSpecs() {
        ArrayList<ImmutablePair> changesSpecs = new ArrayList<ImmutablePair>();
        this.initializeWatermarks();
        this.currentPartitionIdx = -1;
        while (!this.allPartitionsFinished()) {
            if (this.currentPartitionFinished()) {
                this.moveToNextPartition();
                continue;
            }
            if (this.messageIterator == null || !this.messageIterator.hasNext()) {
                try {
                    this.messageIterator = this.fetchNextMessageBuffer();
                }
                catch (Exception e) {
                    log.error(String.format("Failed to fetch next message buffer for partition %s. Will skip this partition.", this.getCurrentPartition()), (Throwable)e);
                    this.moveToNextPartition();
                    continue;
                }
                if (this.messageIterator == null || !this.messageIterator.hasNext()) {
                    this.moveToNextPartition();
                    continue;
                }
            }
            while (!this.currentPartitionFinished() && this.messageIterator.hasNext()) {
                KafkaConsumerRecord nextValidMessage = this.messageIterator.next();
                if (nextValidMessage.getOffset() < this._nextWatermark.get(this.currentPartitionIdx)) continue;
                this._nextWatermark.set(this.currentPartitionIdx, nextValidMessage.getNextOffset());
                try {
                    AvroJobSpec record;
                    if (nextValidMessage instanceof ByteArrayBasedKafkaRecord) {
                        record = this.decodeRecord((ByteArrayBasedKafkaRecord)nextValidMessage);
                    } else if (nextValidMessage instanceof DecodeableKafkaRecord) {
                        record = (AvroJobSpec)((DecodeableKafkaRecord)nextValidMessage).getValue();
                    } else {
                        throw new IllegalStateException("Unsupported KafkaConsumerRecord type. The returned record can either be ByteArrayBasedKafkaRecord or DecodeableKafkaRecord");
                    }
                    JobSpec.Builder jobSpecBuilder = JobSpec.builder((String)record.getUri());
                    Properties props = new Properties();
                    props.putAll((Map<?, ?>)record.getProperties());
                    jobSpecBuilder.withJobCatalogURI(record.getUri()).withVersion(record.getVersion()).withDescription(record.getDescription()).withConfigAsProperties(props);
                    if (!record.getTemplateUri().isEmpty()) {
                        jobSpecBuilder.withTemplate(new URI(record.getTemplateUri()));
                    }
                    String verbName = (String)record.getMetadata().get("Verb");
                    SpecExecutor.Verb verb = SpecExecutor.Verb.valueOf((String)verbName);
                    changesSpecs.add(new ImmutablePair((Object)verb, (Object)jobSpecBuilder.build()));
                }
                catch (Throwable t) {
                    log.error("Could not decode record at partition " + this.currentPartitionIdx + " offset " + nextValidMessage.getOffset());
                }
            }
        }
        return new CompletedFuture(changesSpecs, null);
    }

    private void initializeWatermarks() {
        this.initializeLowWatermarks();
        this.initializeHighWatermarks();
    }

    private void initializeLowWatermarks() {
        try {
            int i = 0;
            for (KafkaPartition kafkaPartition : this._partitions) {
                if (this.isFirstRun) {
                    long earliestOffset = this._kafkaConsumer.getEarliestOffset(kafkaPartition);
                    this._lowWatermark.set(i, earliestOffset);
                } else {
                    this._lowWatermark.set(i, this._highWatermark.get(i));
                }
                ++i;
            }
            this.isFirstRun = false;
        }
        catch (KafkaOffsetRetrievalFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeHighWatermarks() {
        try {
            int i = 0;
            for (KafkaPartition kafkaPartition : this._partitions) {
                long latestOffset = this._kafkaConsumer.getLatestOffset(kafkaPartition);
                this._highWatermark.set(i, latestOffset);
                ++i;
            }
        }
        catch (KafkaOffsetRetrievalFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean allPartitionsFinished() {
        return this.currentPartitionIdx >= this._nextWatermark.size();
    }

    private boolean currentPartitionFinished() {
        if (this.currentPartitionIdx == -1) {
            return true;
        }
        return this._nextWatermark.get(this.currentPartitionIdx) >= this._highWatermark.get(this.currentPartitionIdx);
    }

    private int moveToNextPartition() {
        this.messageIterator = null;
        return this.currentPartitionIdx++;
    }

    private KafkaPartition getCurrentPartition() {
        return this._partitions.get(this.currentPartitionIdx);
    }

    private Iterator<KafkaConsumerRecord> fetchNextMessageBuffer() {
        return this._kafkaConsumer.consume(this._partitions.get(this.currentPartitionIdx), this._nextWatermark.get(this.currentPartitionIdx).longValue(), this._highWatermark.get(this.currentPartitionIdx).longValue());
    }

    private AvroJobSpec decodeRecord(ByteArrayBasedKafkaRecord kafkaConsumerRecord) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(kafkaConsumerRecord.getMessageBytes());
        this._versionWriter.readSchemaVersioningInformation(new DataInputStream(is));
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)is, this._decoder);
        return (AvroJobSpec)this._reader.read(null, (Decoder)decoder);
    }

    @Override
    public void close() throws IOException {
        this._kafkaConsumer.close();
    }
}

